/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easypiglins.blocks.tileentity.PiglinTileentity;
import de.maxhenkel.easypiglins.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easypiglins.corelib.inventory.ItemListInventory;
import de.maxhenkel.easypiglins.corelib.item.ItemUtils;
import de.maxhenkel.easypiglins.gui.BarterSlot;
import de.maxhenkel.easypiglins.inventory.InputOnlyResourceHandler;
import de.maxhenkel.easypiglins.inventory.ListAccessItemStacksResourceHandler;
import de.maxhenkel.easypiglins.inventory.OutputOnlyResourceHandler;
import de.maxhenkel.easypiglins.inventory.ValidateResourceHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class BartererTileentity
extends PiglinTileentity
implements IServerTickableBlockEntity {
    protected ListAccessItemStacksResourceHandler inputInventory = new ValidateResourceHandler(4, BarterSlot::isValid);
    protected ListAccessItemStacksResourceHandler outputInventory = new ListAccessItemStacksResourceHandler(4);
    @Nullable
    protected NonNullList<ItemStack> itemsLeft;
    protected ItemStack barteringItem = ItemStack.EMPTY;
    protected int barteringTimeLeft;
    protected CombinedResourceHandler<ItemResource> itemHandler = new CombinedResourceHandler(new ResourceHandler[]{new InputOnlyResourceHandler((ResourceHandler<ItemResource>)this.inputInventory), new OutputOnlyResourceHandler((ResourceHandler<ItemResource>)this.outputInventory)});

    public BartererTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BARTERER.get(), ((BartererBlock)((Object)ModBlocks.BARTERER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        Piglin p = this.getPiglinEntity();
        if (p == null) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L && this.level.random.nextInt(40) == 0) {
            BartererBlock.playPiglinSound(this.level, this.worldPosition, SoundEvents.PIGLIN_AMBIENT);
        }
        if (this.itemsLeft == null) {
            ItemStack oldBarteringItem = this.barteringItem;
            this.barteringItem = this.removeBarteringItem();
            if (!this.barteringItem.isEmpty()) {
                if (this.level.getRandom().nextInt(5) == 0) {
                    BartererBlock.playPiglinSound(this.level, this.getBlockPos(), SoundEvents.PIGLIN_ADMIRING_ITEM);
                }
                this.itemsLeft = this.generateLoot(p);
                this.barteringTimeLeft = 120;
                this.setChanged();
                this.sync();
            } else if (!oldBarteringItem.equals(this.barteringItem)) {
                this.sync();
            }
        }
        if (this.barteringTimeLeft <= 0) {
            this.insertItems();
        } else {
            --this.barteringTimeLeft;
            this.setChanged();
        }
    }

    public ItemStack removeBarteringItem() {
        try (Transaction t = Transaction.open(null);){
            for (int i = 0; i < this.inputInventory.size(); ++i) {
                ItemResource resource = (ItemResource)this.inputInventory.getResource(i);
                if (!resource.toStack().isPiglinCurrency() || this.inputInventory.getAmountAsInt(i) < 1 || this.inputInventory.extract((Resource)resource, 1, (TransactionContext)t) < 1) continue;
                t.commit();
                ItemStack itemStack = resource.toStack();
                return itemStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getRenderBarteringItem() {
        return this.barteringItem;
    }

    private NonNullList<ItemStack> generateLoot(Piglin piglin) {
        LootTable loottable = this.level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList loot = loottable.getRandomItems(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)piglin).create(LootContextParamSets.PIGLIN_BARTER));
        return NonNullList.copyOf((Collection)loot);
    }

    private void insertItems() {
        if (this.itemsLeft == null) {
            return;
        }
        NonNullList newLeft = NonNullList.create();
        try (Transaction t = Transaction.open(null);){
            for (ItemStack drop : this.itemsLeft) {
                int inserted;
                if (drop.isEmpty() || (inserted = this.outputInventory.insert((Resource)ItemResource.of((ItemStack)drop), drop.getCount(), (TransactionContext)t)) <= 0) continue;
                newLeft.add((Object)drop.split(drop.getCount() - inserted));
            }
            t.commit();
        }
        if (newLeft.isEmpty()) {
            this.itemsLeft = null;
            this.sync();
        } else {
            this.itemsLeft = newLeft;
        }
        this.setChanged();
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput.child("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", this.outputInventory.getRaw());
        if (this.itemsLeft != null) {
            ItemUtils.saveItemList(valueOutput, "ItemsLeft", this.itemsLeft);
        }
        if (!this.barteringItem.isEmpty()) {
            valueOutput.store("BarteringItem", ItemStack.CODEC, (Object)this.barteringItem);
        }
        valueOutput.putInt("BarteringTimeLeft", this.barteringTimeLeft);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        this.inputInventory.getRaw().clear();
        this.outputInventory.getRaw().clear();
        ItemUtils.readItemList(valueInput.childOrEmpty("InputInventory"), "Items", this.inputInventory.getRaw());
        ItemUtils.readItemList(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory.getRaw());
        this.itemsLeft = ItemUtils.readItemList(valueInput, "ItemsLeft", false);
        this.barteringItem = valueInput.read("BarteringItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.barteringTimeLeft = valueInput.getIntOr("BarteringTimeLeft", 0);
        super.loadAdditional(valueInput);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory.getRaw(), () -> ((BartererTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory.getRaw(), () -> ((BartererTileentity)this).setChanged());
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

