/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.events;

import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import de.maxhenkel.easypiglins.items.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PiglinEvents {
    @SubscribeEvent
    public void onClick(PlayerInteractEvent.EntityInteract event) {
        ServerLevel serverLevel;
        Player player;
        Piglin piglin;
        block8: {
            block7: {
                if (!(event.getTarget() instanceof Piglin)) {
                    return;
                }
                piglin = (Piglin)event.getTarget();
                player = event.getEntity();
                Level level = player.level();
                if (!(level instanceof ServerLevel)) break block7;
                serverLevel = (ServerLevel)level;
                if (player.isShiftKeyDown() && !piglin.isBaby()) break block8;
            }
            return;
        }
        if (!piglin.isAlive()) {
            return;
        }
        PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)player, (boolean)true);
        if (!PiglinAi.isWearingSafeArmor((LivingEntity)player) || !piglin.getBrain().isActive(Activity.IDLE)) {
            piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)player.getUUID(), 600L);
            player.displayClientMessage((Component)Component.translatable((String)"message.easy_piglins.cant_pick_up"), true);
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.PIGLIN.get());
        PiglinData.applyToItem(stack, piglin);
        if (player.getInventory().add(stack)) {
            piglin.discard();
        }
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

