/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PiglinRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class PiglinSpecialRenderer
implements SpecialModelRenderer<PiglinRenderState> {
    protected static final Minecraft minecraft = Minecraft.getInstance();
    @Nullable
    private PiglinRenderer renderer;
    private final CameraRenderState cameraRenderState = new CameraRenderState();

    public void submit(@Nullable PiglinRenderState state, ItemDisplayContext context, PoseStack stack, SubmitNodeCollector collector, int light, int overlay, boolean b, int i) {
        if (state == null) {
            return;
        }
        PiglinRenderer piglinRenderer = this.getRenderer();
        state.lightCoords = light;
        piglinRenderer.submit((LivingEntityRenderState)state, stack, collector, this.cameraRenderState);
    }

    public void getExtents(Consumer<Vector3fc> vecs) {
    }

    @Nullable
    public PiglinRenderState extractArgument(ItemStack stack) {
        Piglin cachePiglin = PiglinData.getCachePiglin(stack, (Level)PiglinSpecialRenderer.minecraft.level);
        if (this.renderer == null) {
            this.renderer = (PiglinRenderer)minecraft.getEntityRenderDispatcher().getRenderer((Entity)cachePiglin);
        }
        PiglinRenderState piglinRenderState = this.renderer.createRenderState();
        this.renderer.extractRenderState((AbstractPiglin)cachePiglin, piglinRenderState, 0.0f);
        return piglinRenderState;
    }

    private PiglinRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = PiglinSpecialRenderer.createPiglinRenderer();
        }
        return this.renderer;
    }

    public static PiglinRenderer createPiglinRenderer() {
        return (PiglinRenderer)PiglinSpecialRenderer.minecraft.getEntityRenderDispatcher().renderers.get(EntityType.PIGLIN);
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @Nullable
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new PiglinSpecialRenderer();
        }
    }
}

