/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.corelib.client.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.easypiglins.corelib.client.RenderUtils;
import de.maxhenkel.easypiglins.corelib.client.obj.OBJLoader;
import de.maxhenkel.easypiglins.corelib.client.obj.OBJRenderUtils;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.neoforged.bus.api.IEventBus;
import org.joml.Vector3f;

public class OBJModel {
    private final ResourceLocation model;
    private OBJModelData data;

    public OBJModel(ResourceLocation model) {
        this.model = model;
    }

    private void load() {
        if (this.data == null) {
            this.data = OBJLoader.load(this.model);
        }
    }

    public void submitModels(ResourceLocation texture, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState, int lightCoords) {
        this.load();
        stack.pushPose();
        collector.submitCustomGeometry(stack, OBJRenderUtils.ENTITY_CUTOUT_TRIANGLES.apply(texture), (pose, consumer) -> {
            for (int i = 0; i < this.data.faces.size(); ++i) {
                int[][] face = this.data.faces.get(i);
                RenderUtils.vertex(consumer, pose, this.data.positions.get(face[0][0]), this.data.texCoords.get(face[0][1]), this.data.normals.get(face[0][2]), lightCoords, OverlayTexture.NO_OVERLAY);
                RenderUtils.vertex(consumer, pose, this.data.positions.get(face[1][0]), this.data.texCoords.get(face[1][1]), this.data.normals.get(face[1][2]), lightCoords, OverlayTexture.NO_OVERLAY);
                RenderUtils.vertex(consumer, pose, this.data.positions.get(face[2][0]), this.data.texCoords.get(face[2][1]), this.data.normals.get(face[2][2]), lightCoords, OverlayTexture.NO_OVERLAY);
            }
        });
        stack.popPose();
    }

    public static void registerRenderPipeline(IEventBus bus) {
        bus.addListener(OBJRenderUtils::onRegisterPipelines);
    }

    static class OBJModelData {
        private List<Vector3f> positions;
        private List<Vec2> texCoords;
        private List<Vector3f> normals;
        private List<int[][]> faces;

        public OBJModelData(List<Vector3f> positions, List<Vec2> texCoords, List<Vector3f> normals, List<int[][]> faces) {
            this.positions = positions;
            this.texCoords = texCoords;
            this.normals = normals;
            this.faces = faces;
        }

        public List<Vector3f> getPositions() {
            return this.positions;
        }

        public List<Vec2> getTexCoords() {
            return this.texCoords;
        }

        public List<Vector3f> getNormals() {
            return this.normals;
        }

        public List<int[][]> getFaces() {
            return this.faces;
        }
    }
}

