/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.items.BlockItemDataCache;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ItemSpecialRendererBase<T extends FakeWorldTileentity, U extends BlockEntityRenderState>
implements SpecialModelRenderer<T> {
    protected static final Minecraft minecraft = Minecraft.getInstance();
    protected BlockEntityRenderer<T, U> renderer;
    protected Supplier<BlockState> blockSupplier;
    protected Class<T> typeClass;
    @Nullable
    protected U renderState;
    protected CameraRenderState cameraRenderState;

    public ItemSpecialRendererBase(Supplier<BlockState> blockSupplier, Class<T> typeClass) {
        this.blockSupplier = blockSupplier;
        this.typeClass = typeClass;
        this.cameraRenderState = new CameraRenderState();
        this.cameraRenderState.initialized = true;
    }

    public void submit(@Nullable T blockEntity, ItemDisplayContext context, PoseStack stack, SubmitNodeCollector collector, int light, int overlay, boolean b, int i) {
        collector.submitBlock(stack, this.blockSupplier.get(), light, overlay, -1);
        if (blockEntity == null) {
            return;
        }
        if (this.renderState == null) {
            this.renderState = this.renderer.createRenderState();
        }
        ((BlockEntityRenderState)this.renderState).lightCoords = light;
        this.renderer.extractRenderState(blockEntity, this.renderState, 0.0f, Vec3.ZERO, null);
        ((BlockEntityRenderState)this.renderState).lightCoords = light;
        this.renderer.submit(this.renderState, stack, collector, this.cameraRenderState);
    }

    public void getExtents(Set<Vector3f> vecs) {
    }

    @Nullable
    public T extractArgument(ItemStack stack) {
        return BlockItemDataCache.get((Level)ItemSpecialRendererBase.minecraft.level, stack, this.typeClass);
    }
}

