/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.networking;

import com.simibubi.create.Create;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.fw14.createAddons.accessDenied.AccessDenied;
import net.fw14.createAddons.accessDenied.extensions.LogisticsManagerExtensions;
import net.fw14.createAddons.accessDenied.screen.AccessControlScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class S2CAllowedPlayersSyncPacket {
    private final UUID networkUUID;
    private final Set<UUID> allowedPlayers;

    public S2CAllowedPlayersSyncPacket(UUID network, Set<UUID> set) {
        this.networkUUID = network;
        this.allowedPlayers = set;
    }

    public static S2CAllowedPlayersSyncPacket fromNetworkId(UUID network) {
        return new S2CAllowedPlayersSyncPacket(network, ((LogisticsManagerExtensions)Create.LOGISTICS).accessDenied$getAllowedPlayers(network));
    }

    public static S2CAllowedPlayersSyncPacket read(FriendlyByteBuf buffer) {
        UUID networkUUID = buffer.m_130259_();
        int count = buffer.readByte();
        HashSet<UUID> set = new HashSet<UUID>();
        for (int i = 0; i < count; ++i) {
            UUID uuid = buffer.m_130259_();
            set.add(uuid);
        }
        return new S2CAllowedPlayersSyncPacket(networkUUID, set);
    }

    public static void write(S2CAllowedPlayersSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.networkUUID);
        int count = packet.allowedPlayers.size();
        buffer.writeByte(count);
        packet.allowedPlayers.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (!ctx.get().getDirection().equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            AccessDenied.AllowedPlayersClientState.put(this.networkUUID, this.allowedPlayers);
            this.allowedPlayers.forEach(uuid -> AccessControlScreen.ProfileCache.preCache(uuid, Minecraft.m_91087_()));
        });
        ctx.get().setPacketHandled(true);
    }
}

