/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.trains.schedule.DestinationSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PlayerEditBox
extends EditBox {
    private final DestinationSuggestions destinationSuggestions;
    private final Consumer<String> mainResponder;
    private String prevValue = "=)";

    public PlayerEditBox(Screen screen, Font pFont, int pX, int pY, int pWidth, int pHeight, boolean anchorToBottom) {
        super(pFont, pX, pY, pWidth, pHeight, (Component)Component.empty());
        ArrayList<IntAttached> intAttachedList = new ArrayList<IntAttached>();
        int idx = 0;
        List<GameProfile> server = Minecraft.getInstance().isSingleplayer() ? List.of() : Minecraft.getInstance().getConnection().getOnlinePlayers().stream().map(PlayerInfo::getProfile).toList();
        for (GameProfile player : server) {
            intAttachedList.add(IntAttached.with((int)idx++, (Object)player.getName()));
        }
        this.destinationSuggestions = new DestinationSuggestions(Minecraft.getInstance(), screen, (EditBox)this, pFont, intAttachedList, false, -72 + this.getY() + (anchorToBottom ? 0 : this.getHeight()));
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
        this.mainResponder = t -> {
            if (!t.equals(this.prevValue)) {
                this.destinationSuggestions.updateCommandInfo();
            }
            this.prevValue = t;
        };
        this.setResponder(this.mainResponder);
        this.setBordered(false);
        this.setFocused(false);
        this.mouseClicked(0.0, 0.0, 0);
        this.setMaxLength(25);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.isFocused() && pKeyCode == 257) {
            this.setFocused(false);
            this.moveCursorToEnd(false);
            this.mouseClicked(0.0, 0.0, 0);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta, double scrollY) {
        return this.destinationSuggestions.mouseScrolled(Mth.clamp((double)pDelta, (double)-1.0, (double)1.0)) || super.mouseScrolled(pMouseX, pMouseY, pDelta, scrollY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1 && this.isMouseOver(pMouseX, pMouseY)) {
            this.setValue("");
            return true;
        }
        boolean wasFocused = this.isFocused();
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            if (!wasFocused) {
                this.setHighlightPos(0);
                this.setCursorPosition(this.getValue().length());
            }
            return true;
        }
        return this.destinationSuggestions.mouseClicked((double)((int)pMouseX), (double)((int)pMouseY), pButton);
    }

    public void setValue(String text) {
        this.setHighlightPos(0);
        super.setValue(text);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        PoseStack matrixStack = pGuiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 500.0f);
        this.destinationSuggestions.render(pGuiGraphics, pMouseX, pMouseY);
        matrixStack.popPose();
        if (this.destinationSuggestions.isEmpty()) {
            this.destinationSuggestions.updateCommandInfo();
        }
    }

    public void setResponder(Consumer<String> pResponder) {
        super.setResponder(pResponder == this.mainResponder ? this.mainResponder : this.mainResponder.andThen(pResponder));
    }

    public void tick() {
        if (!this.isFocused()) {
            this.destinationSuggestions.hide();
        }
        this.destinationSuggestions.tick();
    }

    public void hideSuggestions() {
        this.destinationSuggestions.hide();
    }
}

