/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.networking;

import com.simibubi.create.Create;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fw14.createAddons.accessDenied.AccessDenied;
import net.fw14.createAddons.accessDenied.extensions.LogisticsManagerExtensions;
import net.fw14.createAddons.accessDenied.screen.AccessControlScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2CAllowedPlayersSyncPacket(UUID networkUUID, Set<UUID> allowedPlayers) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CAllowedPlayersSyncPacket> TYPE = new CustomPacketPayload.Type(AccessDenied.resLoc("allowed_players_sync"));
    public static final StreamCodec<ByteBuf, S2CAllowedPlayersSyncPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, S2CAllowedPlayersSyncPacket::networkUUID, (StreamCodec)ByteBufCodecs.list().apply(UUIDUtil.STREAM_CODEC).map(Set::copyOf, List::copyOf), S2CAllowedPlayersSyncPacket::allowedPlayers, S2CAllowedPlayersSyncPacket::new);

    public static S2CAllowedPlayersSyncPacket fromNetworkId(UUID network) {
        return new S2CAllowedPlayersSyncPacket(network, ((LogisticsManagerExtensions)Create.LOGISTICS).accessDenied$getAllowedPlayers(network));
    }

    public static void handle(S2CAllowedPlayersSyncPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AccessDenied.AllowedPlayersClientState.put(data.networkUUID, data.allowedPlayers);
            data.allowedPlayers.forEach(playerUUID -> AccessControlScreen.ProfileCache.preCache(playerUUID, Minecraft.getInstance()));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

