/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.fw14.createAddons.accessDenied.AccessDenied;
import net.fw14.createAddons.accessDenied.client.AccessDeniedClient;
import net.fw14.createAddons.accessDenied.networking.C2SModifyAllowedPlayersPacket;
import net.fw14.createAddons.accessDenied.screen.PlayerEditBox;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

public class AccessControlScreen
extends Screen {
    private final UUID networkId;
    private final Screen parent;
    private static final ResourceLocation UI_RL = AccessDenied.resLoc("textures/gui/ui_background.png");
    private static final int UI_WIDTH = 192;
    private static final int UI_HEIGHT = 119;
    private static final int ADD_BUTTON_START_X = 170;
    private static final int ADD_BUTTON_START_Y = 98;
    private static final int ADD_BUTTON_SIZE = 18;
    public static final int HEAD_SIZE = 13;
    public static final int WRAP_COUNT = 9;
    private PlayerEditBox playerUsernameBox;
    static Font font;
    private static final Map<UUID, ProfileCache> profileCache;

    public AccessControlScreen(UUID networkId, Screen parent) {
        super((Component)Component.translatable((String)"create_access_denied.screen.access_control"));
        this.networkId = networkId;
        this.parent = parent;
    }

    protected void init() {
        GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212993);
        int uiStartX = this.width / 2 - 96;
        int uiStartY = this.height / 2 - 59;
        font = new NoShadowFontWrapper(this.minecraft.font);
        PlayerEditBox box = (PlayerEditBox)this.addRenderableWidget((GuiEventListener)new PlayerEditBox(this, font, uiStartX + 10, uiStartY + 103, 157, 16, false));
        box.setBordered(false);
        box.setFocused(true);
        box.setMaxLength(16);
        box.setTextColor(0xFFFFFF);
        this.playerUsernameBox = box;
    }

    public void tick() {
        if (this.playerUsernameBox != null) {
            if (this.playerUsernameBox.isFocused()) {
                this.playerUsernameBox.tick();
            } else {
                this.playerUsernameBox.hideSuggestions();
            }
        }
        super.tick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        super.renderBackground(graphics, mouseX, mouseY, f);
        int uiStartX = this.width / 2 - 96;
        int uiStartY = this.height / 2 - 59;
        graphics.blit(UI_RL, uiStartX, uiStartY, 0, 0, 192, 119);
        graphics.blit(UI_RL, uiStartX - 16, uiStartY - 16, 208, 0, 48, 48);
        graphics.drawCenteredString(font, (Component)Component.translatable((String)"create_access_denied.screen.access_control"), this.width / 2, uiStartY + 4, 4015931);
        if (this.atLimit()) {
            graphics.blit(UI_RL, uiStartX + 170, uiStartY + 98, 208, 80, 18, 18);
            if (this.isHoveringButton(mouseX, mouseY)) {
                graphics.renderComponentTooltip(this.minecraft.font, List.of(Component.translatable((String)"create_access_denied.screen.at_limit", (Object[])new Object[]{18})), mouseX, mouseY);
            }
        } else if (this.isHoveringButton(mouseX, mouseY)) {
            graphics.blit(UI_RL, uiStartX + 170, uiStartY + 98, 208, 48, 18, 18);
        }
        graphics.drawString(font, (Component)Component.translatable((String)"create_access_denied.screen.players"), uiStartX + 12, uiStartY + 23, 15584701);
        int playerRenderX = uiStartX - 6;
        int playerRenderY = uiStartY + 36;
        Set<UUID> networkAllowedPlayers = AccessDenied.AllowedPlayersClientState.get(this.networkId);
        int playerIdx = 0;
        for (UUID player : networkAllowedPlayers) {
            boolean isHovering;
            ProfileCache profile = ProfileCache.get(player, this.minecraft);
            int x = playerRenderX += 19;
            boolean bl = isHovering = mouseX > playerRenderX - 2 && mouseX <= playerRenderX + 13 + 3 && mouseY > playerRenderY - 2 && mouseY < playerRenderY + 13 + 3;
            if (isHovering) {
                graphics.fill(x - 3, playerRenderY - 3, x + 13 + 3, playerRenderY + 13 + 3, 0x22000000);
                profile.renderSkin(graphics, x, playerRenderY, 13);
                graphics.renderComponentTooltip(this.minecraft.font, List.of(Component.literal((String)profile.profile.getName()), Component.translatable((String)"create_access_denied.screen.remove_hint").withStyle(ChatFormatting.GRAY)), mouseX, mouseY);
            } else {
                profile.renderSkin(graphics, x, playerRenderY, 13);
            }
            if (++playerIdx % 9 != 0) continue;
            playerRenderY += 17;
            playerRenderX = uiStartX - 6;
        }
        if (networkAllowedPlayers.isEmpty()) {
            graphics.drawCenteredString(font, (Component)Component.translatable((String)"create_access_denied.screen.no_players").withStyle(ChatFormatting.ITALIC), this.width / 2, this.height / 2 - 4, -1997681219);
        }
        if (this.isHovering(mouseX, mouseY, uiStartX - 7, uiStartY + 119 + 4, 55, 15)) {
            graphics.blit(UI_RL, uiStartX - 7, uiStartY + 119 + 4, 0, 160, 55, 15);
            graphics.drawCenteredString(font, (Component)Component.translatable((String)"gui.done"), uiStartX + 22, uiStartY + 119 + 8, 4015931);
        } else {
            graphics.blit(UI_RL, uiStartX - 7, uiStartY + 119 + 4, 0, 144, 55, 15);
            graphics.drawCenteredString(font, (Component)Component.translatable((String)"gui.done"), uiStartX + 22, uiStartY + 119 + 8, 0x323232);
        }
        this.playerUsernameBox.active = !this.atLimit();
        this.playerUsernameBox.render(graphics, mouseX, mouseY, f);
    }

    boolean isHovering(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX > (double)x && mouseX < (double)(x + w) && mouseY > (double)y && mouseY < (double)(y + h);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int uiStartX = this.width / 2 - 96;
        int uiStartY = this.height / 2 - 59;
        if (this.isHovering(mouseX, mouseY, uiStartX - 7, uiStartY + 119 + 4, 55, 15) && mouseButton == 0) {
            this.minecraft.setScreen(this.parent);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.2f));
            return true;
        }
        if (this.isHoveringButton(mouseX, mouseY) && mouseButton == 0) {
            this.submitToAdd();
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.2f));
            return true;
        }
        if (!AccessControlScreen.hasShiftDown()) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        int playerRenderX = uiStartX - 6;
        int playerRenderY = uiStartY + 36;
        Set<UUID> networkAllowedPlayers = AccessDenied.AllowedPlayersClientState.get(this.networkId);
        int playerIdx = 0;
        for (UUID player : networkAllowedPlayers) {
            boolean isHovering;
            ProfileCache profile = ProfileCache.get(player, this.minecraft);
            boolean bl = isHovering = mouseX > (double)((playerRenderX += 19) - 2) && mouseX <= (double)(playerRenderX + 13 + 3) && mouseY > (double)(playerRenderY - 2) && mouseY < (double)(playerRenderY + 13 + 3);
            if (isHovering) {
                this.submitToRemove(profile);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.2f));
                return true;
            }
            if (++playerIdx % 9 != 0) continue;
            playerRenderY += 17;
            playerRenderX = uiStartX - 6;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int p_96553_, int p_96554_) {
        if (keyCode == 257 && this.playerUsernameBox.isFocused()) {
            this.submitToAdd();
            return true;
        }
        return super.keyPressed(keyCode, p_96553_, p_96554_);
    }

    boolean isHoveringButton(double mouseX, double mouseY) {
        int uiStartX = this.width / 2 - 96;
        int uiStartY = this.height / 2 - 59;
        return this.isHovering(mouseX, mouseY, uiStartX + 170, uiStartY + 98, 18, 18);
    }

    boolean atLimit() {
        Set<UUID> networkAllowedPlayers = AccessDenied.AllowedPlayersClientState.get(this.networkId);
        return networkAllowedPlayers.size() >= 18;
    }

    private void submitToAdd() {
        if (this.atLimit()) {
            return;
        }
        String value = this.playerUsernameBox.getValue();
        if (value.length() < 3) {
            return;
        }
        this.playerUsernameBox.setValue("");
        Optional<ProfileCache> cachedProfile = profileCache.values().stream().filter(v -> v.profile.getName().equalsIgnoreCase(value)).findFirst();
        if (cachedProfile.isPresent()) {
            PacketDistributor.sendToServer((CustomPacketPayload)C2SModifyAllowedPlayersPacket.add(this.networkId, cachedProfile.get().profile().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        CompletableFuture.runAsync(() -> AccessDeniedClient.fetchProfileByUsername(value).whenComplete((profile, exception) -> {
            if (exception != null || profile == null) {
                return;
            }
            ProfileCache.preCache(profile.getId(), this.minecraft);
            PacketDistributor.sendToServer((CustomPacketPayload)C2SModifyAllowedPlayersPacket.add(this.networkId, profile.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
    }

    private void submitToRemove(ProfileCache cached) {
        PacketDistributor.sendToServer((CustomPacketPayload)C2SModifyAllowedPlayersPacket.remove(this.networkId, cached.profile().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }

    static {
        profileCache = new ConcurrentHashMap<UUID, ProfileCache>();
    }

    public record ProfileCache(GameProfile profile, ResourceLocation skinLocation) {
        public static ProfileCache get(UUID uuid, Minecraft minecraft) {
            if (profileCache.containsKey(uuid)) {
                return profileCache.get(uuid);
            }
            ProfileResult profileFetched = minecraft.getMinecraftSessionService().fetchProfile(uuid, false);
            if (profileFetched == null) {
                return new ProfileCache(new GameProfile(uuid, uuid.toString()), minecraft.getSkinManager().getInsecureSkin(new GameProfile(uuid, uuid.toString())).texture());
            }
            return ProfileCache.addFetched(profileFetched.profile(), minecraft);
        }

        public static void preCache(UUID playerUUID, Minecraft minecraft) {
            CompletableFuture.runAsync(() -> ProfileCache.get(playerUUID, minecraft));
        }

        public static ProfileCache addFetched(GameProfile profile, Minecraft minecraft) {
            PlayerSkin skin = minecraft.getSkinManager().getInsecureSkin(profile);
            ProfileCache toCache = new ProfileCache(profile, skin.texture());
            profileCache.put(profile.getId(), toCache);
            minecraft.getSkinManager().getOrLoad(profile).whenComplete((fetchedSkin, throwable) -> profileCache.put(profile.getId(), new ProfileCache(profile, fetchedSkin.texture())));
            return toCache;
        }

        public void renderSkin(GuiGraphics guiGraphics, int x, int y, int k) {
            guiGraphics.blit(this.skinLocation, x, y, k, k, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(this.skinLocation, x - 1, y - 1, k + 2, k + 2, 40.0f, 8.0f, 8, 8, 64, 64);
        }
    }
}

