/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.networking;

import com.simibubi.create.Create;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fw14.createAddons.accessDenied.AccessDenied;
import net.fw14.createAddons.accessDenied.extensions.LogisticNetworkExtensions;
import net.fw14.createAddons.accessDenied.networking.S2CAllowedPlayersSyncPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class C2SModifyAllowedPlayersPacket {
    private final UUID networkId;
    private final Mode mode;
    @Nullable
    private final UUID playerUUID;

    public C2SModifyAllowedPlayersPacket(UUID networkId, Mode mode, @Nullable UUID playerUUID) {
        if (mode.requiresId && playerUUID == null) {
            throw new RuntimeException("Mode " + String.valueOf((Object)mode) + " requries player UUID!");
        }
        this.networkId = networkId;
        this.mode = mode;
        this.playerUUID = playerUUID;
    }

    public static C2SModifyAllowedPlayersPacket read(FriendlyByteBuf buffer) {
        UUID networkId = buffer.m_130259_();
        Optional<Mode> oMode = Mode.fromId(buffer.readByte());
        if (oMode.isEmpty()) {
            throw new RuntimeException("Invalid Mode supplied!");
        }
        Mode mode = oMode.get();
        UUID playerId = null;
        if (mode.requiresId) {
            playerId = buffer.m_130259_();
        }
        return new C2SModifyAllowedPlayersPacket(networkId, mode, playerId);
    }

    public static C2SModifyAllowedPlayersPacket add(UUID networkId, UUID playerUUID) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.ADD, playerUUID);
    }

    public static C2SModifyAllowedPlayersPacket remove(UUID networkId, UUID playerUUID) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.REMOVE, playerUUID);
    }

    public static C2SModifyAllowedPlayersPacket clear(UUID networkId) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.CLEAR, null);
    }

    public static void write(C2SModifyAllowedPlayersPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.networkId);
        buffer.writeByte((int)packet.mode.type);
        if (packet.mode.requiresId && packet.playerUUID != null) {
            buffer.m_130077_(packet.playerUUID);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (!ctx.get().getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            if (!Create.LOGISTICS.mayAdministrate(this.networkId, (Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                return;
            }
            LogisticNetworkExtensions network = (LogisticNetworkExtensions)Create.LOGISTICS.logisticsNetworks.get(this.networkId);
            switch (this.mode) {
                case ADD: {
                    network.accessDenied$addAllowedPlayer(this.playerUUID);
                    break;
                }
                case REMOVE: {
                    network.accessDenied$removeAllowedPlayer(this.playerUUID);
                    break;
                }
                case CLEAR: {
                    network.accessDenied$clearAllowedPlayers();
                }
            }
            Create.LOGISTICS.markDirty();
            AccessDenied.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> C2SModifyAllowedPlayersPacket.lambda$handle$0((Supplier)ctx)), (Object)S2CAllowedPlayersSyncPacket.fromNetworkId(this.networkId));
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }

    public static enum Mode {
        ADD(1, true),
        REMOVE(2, true),
        CLEAR(3, false);

        private final byte type;
        private final boolean requiresId;

        private Mode(byte type, boolean requiresId) {
            this.type = type;
            this.requiresId = requiresId;
        }

        public byte type() {
            return this.type;
        }

        public boolean requiresId() {
            return this.requiresId;
        }

        public static Optional<Mode> fromId(byte id) {
            return Arrays.stream(Mode.values()).filter(v -> v.type == id).findFirst();
        }
    }
}

