/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.mixin;

import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fw14.createAddons.accessDenied.extensions.LogisticNetworkExtensions;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LogisticsNetwork.class})
public class LogisticNetworkMixin
implements LogisticNetworkExtensions {
    @Unique
    public Set<UUID> accessDenied$allowedPlayers = new HashSet<UUID>();

    @Inject(at={@At(value="RETURN")}, method={"read"}, remap=false)
    private static void readAllowedPlayers(CompoundTag tag, HolderLookup.Provider registries, CallbackInfoReturnable<LogisticsNetwork> cir) {
        LogisticsNetwork network = (LogisticsNetwork)cir.getReturnValue();
        if (!tag.contains("AllowedPlayers")) {
            return;
        }
        ListTag list = (ListTag)tag.get("AllowedPlayers");
        HashSet<UUID> players = new HashSet<UUID>();
        players.addAll(list.stream().map(NbtUtils::loadUUID).toList());
        ((LogisticNetworkMixin)network).accessDenied$allowedPlayers = players;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"write"}, remap=false)
    public CompoundTag writeAllowedPlayers(CompoundTag tag) {
        ListTag list = new ListTag();
        List<IntArrayTag> uuids = this.accessDenied$allowedPlayers.stream().map(NbtUtils::createUUID).toList();
        list.addAll(uuids);
        tag.put("AllowedPlayers", (Tag)list);
        return tag;
    }

    @Override
    @Unique
    public Set<UUID> accessDenied$getAllowedPlayers() {
        return this.accessDenied$allowedPlayers;
    }

    @Override
    @Unique
    public void accessDenied$addAllowedPlayer(UUID uuid) {
        if (this.accessDenied$allowedPlayers.size() >= 18) {
            return;
        }
        this.accessDenied$allowedPlayers.add(uuid);
    }

    @Override
    @Unique
    public void accessDenied$removeAllowedPlayer(UUID uuid) {
        this.accessDenied$allowedPlayers.remove(uuid);
    }

    @Override
    @Unique
    public void accessDenied$clearAllowedPlayers() {
        this.accessDenied$allowedPlayers.clear();
    }
}

