/*
 * Decompiled with CFR 0.152.
 */
package net.fw14.createAddons.accessDenied.networking;

import com.simibubi.create.Create;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fw14.createAddons.accessDenied.AccessDenied;
import net.fw14.createAddons.accessDenied.extensions.LogisticNetworkExtensions;
import net.fw14.createAddons.accessDenied.networking.S2CAllowedPlayersSyncPacket;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record C2SModifyAllowedPlayersPacket(UUID networkId, Mode mode, @Nullable UUID playerUUID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<C2SModifyAllowedPlayersPacket> TYPE = new CustomPacketPayload.Type(AccessDenied.resLoc("modify_allowed_players"));
    public static final StreamCodec<ByteBuf, C2SModifyAllowedPlayersPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SModifyAllowedPlayersPacket::networkId, (StreamCodec)ByteBufCodecs.BYTE.map(Mode::fromIdF, Mode::type), C2SModifyAllowedPlayersPacket::mode, (StreamCodec)UUIDUtil.STREAM_CODEC, C2SModifyAllowedPlayersPacket::getPlayerUUID, C2SModifyAllowedPlayersPacket::new);

    public static C2SModifyAllowedPlayersPacket add(UUID networkId, UUID playerUUID) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.ADD, playerUUID);
    }

    public static C2SModifyAllowedPlayersPacket remove(UUID networkId, UUID playerUUID) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.REMOVE, playerUUID);
    }

    public static C2SModifyAllowedPlayersPacket clear(UUID networkId) {
        return new C2SModifyAllowedPlayersPacket(networkId, Mode.CLEAR, new UUID(0L, 0L));
    }

    public UUID getPlayerUUID() {
        if (this.playerUUID == null) {
            return new UUID(0L, 0L);
        }
        return this.playerUUID;
    }

    public static void handle(C2SModifyAllowedPlayersPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (!Create.LOGISTICS.mayAdministrate(packet.networkId, ctx.player())) {
                return;
            }
            LogisticNetworkExtensions network = (LogisticNetworkExtensions)Create.LOGISTICS.logisticsNetworks.get(packet.networkId);
            switch (packet.mode.ordinal()) {
                case 0: {
                    network.accessDenied$addAllowedPlayer(packet.playerUUID());
                    break;
                }
                case 1: {
                    network.accessDenied$removeAllowedPlayer(packet.playerUUID());
                    break;
                }
                case 2: {
                    network.accessDenied$clearAllowedPlayers();
                    break;
                }
                case 3: {
                    return;
                }
            }
            Create.LOGISTICS.markDirty();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)ctx.player()), (CustomPacketPayload)S2CAllowedPlayersSyncPacket.fromNetworkId(packet.networkId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Mode {
        ADD(1, true),
        REMOVE(2, true),
        CLEAR(3, false),
        NOOP(0, false);

        private final byte type;
        private final boolean requiresId;

        private Mode(byte type, boolean requiresId) {
            this.type = type;
            this.requiresId = requiresId;
        }

        public byte type() {
            return this.type;
        }

        public boolean requiresId() {
            return this.requiresId;
        }

        public static Optional<Mode> fromId(byte id) {
            return Arrays.stream(Mode.values()).filter(v -> v.type == id).findFirst();
        }

        public static Mode fromIdF(byte id) {
            return Mode.fromId(id).orElseGet(() -> NOOP);
        }
    }
}

