/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz;

import com.zetaplugins.lifestealz.api.LifeStealZAPI;
import com.zetaplugins.lifestealz.api.LifeStealZAPIImpl;
import com.zetaplugins.lifestealz.caches.EliminatedPlayersCache;
import com.zetaplugins.lifestealz.caches.OfflinePlayerCache;
import com.zetaplugins.lifestealz.storage.MariaDBStorage;
import com.zetaplugins.lifestealz.storage.MySQLStorage;
import com.zetaplugins.lifestealz.storage.SQLiteStorage;
import com.zetaplugins.lifestealz.storage.Storage;
import com.zetaplugins.lifestealz.util.AsyncTaskManager;
import com.zetaplugins.lifestealz.util.BypassManager;
import com.zetaplugins.lifestealz.util.ConfigManager;
import com.zetaplugins.lifestealz.util.GracePeriodManager;
import com.zetaplugins.lifestealz.util.LanguageManager;
import com.zetaplugins.lifestealz.util.PapiExpansion;
import com.zetaplugins.lifestealz.util.VersionChecker;
import com.zetaplugins.lifestealz.util.WebHookManager;
import com.zetaplugins.lifestealz.util.customblocks.ReviveBeaconEffectManager;
import com.zetaplugins.lifestealz.util.customitems.recipe.RecipeManager;
import com.zetaplugins.lifestealz.util.geysermc.GeyserManager;
import com.zetaplugins.lifestealz.util.geysermc.GeyserPlayerFile;
import com.zetaplugins.lifestealz.util.revive.ReviveTaskManager;
import com.zetaplugins.lifestealz.util.worldguard.WorldGuardManager;
import com.zetaplugins.zetacore.ZetaCorePlugin;
import com.zetaplugins.zetacore.services.bStats.Metrics;
import com.zetaplugins.zetacore.services.commands.AutoCommandRegistrar;
import com.zetaplugins.zetacore.services.events.AutoEventRegistrar;
import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class LifeStealZ
extends ZetaCorePlugin {
    private static final String PACKAGE_PREFIX = "com.zetaplugins.lifestealz";
    private VersionChecker versionChecker;
    private Storage storage;
    private WorldGuardManager worldGuardManager;
    private LanguageManager languageManager;
    private ConfigManager configManager;
    private RecipeManager recipeManager;
    private GeyserManager geyserManager;
    private GeyserPlayerFile geyserPlayerFile;
    private WebHookManager webHookManager;
    private GracePeriodManager gracePeriodManager;
    private BypassManager bypassManager;
    private EliminatedPlayersCache eliminatedPlayersCache;
    private OfflinePlayerCache offlinePlayerCache;
    private AsyncTaskManager asyncTaskManager;
    private ReviveBeaconEffectManager reviveBeaconEffectManager;
    private ReviveTaskManager reviveTaskManager;
    private final boolean hasWorldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
    private final boolean hasPlaceholderApi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private final boolean hasGeyser = Bukkit.getPluginManager().getPlugin("floodgate") != null;

    public void onLoad() {
        this.getLogger().info("Loading LifeStealZ...");
        if (Bukkit.getName().toLowerCase().contains("spigot") || Bukkit.getName().toLowerCase().contains("craftbukkit")) {
            this.getLogger().severe("---------------------------------------------------");
            this.getLogger().severe("LifeStealZ does not support Spigot or Bukkit!");
            this.getLogger().severe("Please use Paper or any fork of Paper (like Purpur). If you need further assistance, please join our Discord server:");
            this.getLogger().severe("https://strassburger.org/discord");
            this.getLogger().severe("---------------------------------------------------");
        }
        if (this.hasWorldGuard()) {
            this.getLogger().info("WorldGuard found! Enabling WorldGuard support...");
            this.worldGuardManager = new WorldGuardManager();
            this.getLogger().info("WorldGuard found! Enabled WorldGuard support!");
        }
    }

    public void onEnable() {
        PapiExpansion papiExpansion;
        if (this.hasGeyser()) {
            this.getLogger().info("Geyser found, enabling Bedrock player support.");
            this.geyserPlayerFile = new GeyserPlayerFile();
            this.geyserManager = new GeyserManager();
        }
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.asyncTaskManager = new AsyncTaskManager();
        this.reviveBeaconEffectManager = new ReviveBeaconEffectManager(this);
        this.reviveTaskManager = new ReviveTaskManager();
        this.languageManager = new LanguageManager(this);
        this.configManager = new ConfigManager(this);
        this.storage = this.createPlayerDataStorage();
        this.storage.init();
        this.recipeManager = new RecipeManager(this);
        this.recipeManager.registerRecipes();
        this.versionChecker = new VersionChecker(this, "l8Uv7FzS");
        this.gracePeriodManager = new GracePeriodManager(this);
        this.bypassManager = new BypassManager(this);
        this.webHookManager = new WebHookManager(this);
        this.eliminatedPlayersCache = new EliminatedPlayersCache(this);
        this.offlinePlayerCache = new OfflinePlayerCache(this);
        List<String> registeredCommands = new AutoCommandRegistrar(this, PACKAGE_PREFIX).registerAllCommands();
        this.getLogger().info("Registered " + registeredCommands.size() + " commands");
        List<String> registeredEvents = new AutoEventRegistrar(this, PACKAGE_PREFIX).registerAllListeners();
        this.getLogger().info("Registered " + registeredEvents.size() + " event listeners");
        this.initializeBStats();
        if (this.hasPlaceholderApi() && (papiExpansion = new PapiExpansion(this)).canRegister()) {
            papiExpansion.register();
            this.getLogger().info("PlaceholderAPI found! Enabled PlaceholderAPI support!");
        }
        this.getLogger().info("LifeStealZ enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Canceling all running tasks...");
        this.asyncTaskManager.cancelAllTasks();
        this.reviveBeaconEffectManager.clearAllEffects();
        this.getLogger().info("LifeStealZ disabled!");
    }

    public static LifeStealZ getInstance() {
        return (LifeStealZ)JavaPlugin.getPlugin(LifeStealZ.class);
    }

    public static LifeStealZAPI getAPI() {
        return new LifeStealZAPIImpl(LifeStealZ.getInstance());
    }

    public AsyncTaskManager getAsyncTaskManager() {
        return this.asyncTaskManager;
    }

    public ReviveBeaconEffectManager getReviveBeaconEffectManager() {
        return this.reviveBeaconEffectManager;
    }

    public ReviveTaskManager getReviveTaskManager() {
        return this.reviveTaskManager;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public EliminatedPlayersCache getEliminatedPlayersCache() {
        return this.eliminatedPlayersCache;
    }

    public OfflinePlayerCache getOfflinePlayerCache() {
        return this.offlinePlayerCache;
    }

    public WorldGuardManager getWorldGuardManager() {
        return this.worldGuardManager;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public GracePeriodManager getGracePeriodManager() {
        return this.gracePeriodManager;
    }

    public BypassManager getBypassManager() {
        return this.bypassManager;
    }

    public GeyserManager getGeyserManager() {
        return this.geyserManager;
    }

    public GeyserPlayerFile getGeyserPlayerFile() {
        return this.geyserPlayerFile;
    }

    public boolean hasWorldGuard() {
        return this.hasWorldGuard;
    }

    public boolean hasPlaceholderApi() {
        return this.hasPlaceholderApi;
    }

    public boolean hasGeyser() {
        return this.hasGeyser;
    }

    public WebHookManager getWebHookManager() {
        return this.webHookManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private Storage createPlayerDataStorage() {
        switch (this.getConfigManager().getStorageConfig().getString("type").toLowerCase()) {
            case "mysql": {
                this.getLogger().info("Using MySQL storage");
                return new MySQLStorage(this);
            }
            case "sqlite": {
                this.getLogger().info("Using SQLite storage");
                return new SQLiteStorage(this);
            }
            case "mariadb": {
                this.getLogger().info("Using MariaDB storage");
                return new MariaDBStorage(this);
            }
        }
        this.getLogger().warning("Invalid storage type in config.yml! Using SQLite storage as fallback.");
        return new SQLiteStorage(this);
    }

    public static void setMaxHealth(Player player, double maxHealth) {
        AttributeInstance attribute = player.getAttribute(Attribute.MAX_HEALTH);
        if (attribute != null) {
            attribute.setBaseValue(maxHealth);
        }
    }

    private void initializeBStats() {
        int pluginId = 18735;
        Metrics metrics = this.createBStatsMetrics(pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("storage_type", () -> this.getConfigManager().getStorageConfig().getString("type")));
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("lang")));
    }

    @Override
    public File getPluginFile() {
        return this.getFile();
    }
}

