/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.storage.connectionPool;

import com.zetaplugins.lifestealz.storage.connectionPool.ConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public final class SQLiteConnectionPool
implements ConnectionPool {
    private final String connectionUrl;

    public SQLiteConnectionPool(String path) {
        this.connectionUrl = "jdbc:sqlite:" + path;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return DriverManager.getConnection(this.connectionUrl);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create connection to SQLite database: " + e.getMessage());
        }
    }

    @Override
    public void releaseConnection(Connection connection) {
    }

    @Override
    public void shutdown() {
    }
}

