/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug.uploader;

import com.zetaplugins.zetacore.debug.data.DebugReport;
import com.zetaplugins.zetacore.debug.uploader.ReportUploader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ZetaDebugReportUploader
extends ReportUploader {
    public ZetaDebugReportUploader(JavaPlugin plugin) {
        super(plugin);
    }

    public static String uploadReport(DebugReport debugReport, JavaPlugin plugin) {
        return new ZetaDebugReportUploader(plugin).uploadReport(debugReport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    String uploadReport(DebugReport debugReport) {
        try {
            BufferedReader reader;
            String uploadUrl = "https://debug.zetaplugins.com/api/reports/";
            HttpURLConnection connection = this.getHttpURLConnection(new URL(uploadUrl));
            connection.setRequestProperty("Content-Type", "application/json");
            JSONObject jsonReport = debugReport.toJson();
            String jsonString = jsonReport.toJSONString();
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonString.getBytes(StandardCharsets.UTF_8);
                os.write(input);
            }
            int status = connection.getResponseCode();
            if (status == 200 || status == 201) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String line;
                    StringBuilder responseBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        responseBuilder.append(line);
                    }
                    JSONObject jsonResponse = (JSONObject)JSONValue.parse((String)responseBuilder.toString());
                    String statusStr = (String)jsonResponse.get((Object)"status");
                    String link = (String)jsonResponse.get((Object)"link");
                    if ("success".equalsIgnoreCase(statusStr)) {
                        String string = link;
                        return string;
                    }
                    this.getPlugin().getLogger().warning("Debug report upload failed: " + statusStr);
                    String string = null;
                    return string;
                }
                finally {
                    reader.close();
                }
            }
            if (status != 400) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Debug report upload HTTP error code: " + status);
                return null;
            }
            reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
            try {
                String line;
                StringBuilder errorResponse = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    errorResponse.append(line);
                }
                this.getPlugin().getLogger().warning("Debug report upload returned 400 Bad Request: " + String.valueOf(errorResponse));
                return null;
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            this.getPlugin().getLogger().log(Level.WARNING, "Failed to upload debug report", e);
        }
        return null;
    }

    @Override
    boolean isReady() {
        return false;
    }
}

