/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug;

import com.zetaplugins.zetacore.debug.data.DebugReport;
import com.zetaplugins.zetacore.debug.data.InstalledPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class ReportDataCollector {
    private static final int MAX_LOG_LINES = 1000;
    private final JavaPlugin plugin;
    private final File pluginFile;
    private final Map<String, String> configs;
    private final String modrinthId;

    public ReportDataCollector(String modrinthId, JavaPlugin plugin, File pluginFile, Map<String, String> configs) {
        this.plugin = plugin;
        this.pluginFile = pluginFile;
        this.configs = configs;
        this.modrinthId = modrinthId;
    }

    public static DebugReport collect(String modrinthId, JavaPlugin plugin, File pluginFile, Map<String, String> configs) {
        return new ReportDataCollector(modrinthId, plugin, pluginFile, configs).collectReport();
    }

    public DebugReport collectReport() {
        long now = System.currentTimeMillis();
        String pluginName = this.plugin.getName();
        String pluginVersion = this.plugin.getDescription().getVersion();
        String pluginHash = this.generatePluginHash();
        String minecraftVersion = Bukkit.getVersion();
        String serverSoftware = Bukkit.getName();
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String latestLogs = this.getLatestLogs();
        Set<InstalledPlugin> installedPlugins = Arrays.stream(this.plugin.getServer().getPluginManager().getPlugins()).map(p -> new InstalledPlugin(p.getName(), p.getDescription().getVersion(), p.isEnabled())).collect(Collectors.toSet());
        return new DebugReport(this.modrinthId, now, pluginName, pluginVersion, pluginHash, minecraftVersion, javaVersion, serverSoftware, osName, osVersion, latestLogs, installedPlugins, this.configs);
    }

    private String generatePluginHash() {
        try {
            if (this.pluginFile == null || !this.pluginFile.exists()) {
                return "UNKNOWN";
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(this.pluginFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hashBytes = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte hashByte : hashBytes) {
                hexString.append(String.format("%02x", hashByte));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to generate plugin hash", e);
            return "ERROR";
        }
    }

    private File getLogFile() {
        File logFile = new File("logs/latest.log");
        if (!logFile.exists()) {
            File serverDir = new File(".");
            Optional<File> latestLog = Arrays.stream(serverDir.listFiles()).filter(f -> f.isFile() && f.getName().endsWith(".log")).max(Comparator.comparingLong(File::lastModified));
            if (latestLog.isPresent()) {
                logFile = latestLog.get();
            } else {
                return null;
            }
        }
        return logFile;
    }

    private String getLatestLogs() {
        File logFile = this.getLogFile();
        if (logFile == null) {
            return "No log file found";
        }
        try {
            List<String> allLines = Files.readAllLines(logFile.toPath());
            List<String> lastLines = allLines.size() > 1000 ? allLines.subList(allLines.size() - 1000, allLines.size()) : allLines;
            StringBuilder builder = new StringBuilder();
            for (String line : lastLines) {
                builder.append(line).append("\n");
            }
            return ReportDataCollector.maskIpAddresses(builder.toString());
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to read latest log file", e);
            return "ERROR";
        }
    }

    private static String maskIpAddresses(String input) {
        String ipRegex = "\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b";
        Pattern pattern = Pattern.compile(ipRegex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String ip = matcher.group();
            matcher.appendReplacement(result, "***.***.***.***");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String maskIpv6Addresses(String input) {
        String ipv6Regex = "\\b(?:[\\da-fA-F]{1,4}:){1,7}[\\da-fA-F]{1,4}\\b|\\b(?:[\\da-fA-F]{1,4}:){1,7}:|::(?:[\\da-fA-F]{1,4}:){0,6}[\\da-fA-F]{1,4}\\b";
        Pattern pattern = Pattern.compile(ipv6Regex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, "****:****:****:****:****:****:****:****");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

