/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.util;

import com.zetaplugins.lifestealz.LifeStealZ;
import com.zetaplugins.lifestealz.storage.PlayerData;
import com.zetaplugins.lifestealz.util.CooldownManager;
import com.zetaplugins.lifestealz.util.GracePeriodManager;
import com.zetaplugins.lifestealz.util.MaxHeartsManager;
import com.zetaplugins.lifestealz.util.TimeFormatter;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PapiExpansion
extends PlaceholderExpansion {
    private final LifeStealZ plugin;

    public PapiExpansion(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "Kartoffelchipss";
    }

    @NotNull
    public String getIdentifier() {
        return "lifestealz";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        if (player == null || player.getPlayer() == null) {
            return "PlayerNotFound";
        }
        switch (identifier) {
            case "name": {
                return player.getName();
            }
            case "hearts": {
                AttributeInstance attribute;
                Player onlinePlayer = player.getPlayer();
                if (onlinePlayer != null && (attribute = onlinePlayer.getAttribute(Attribute.MAX_HEALTH)) != null) {
                    return String.valueOf((int)(attribute.getBaseValue() / 2.0));
                }
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf((int)(playerData.getMaxHealth() / 2.0));
            }
            case "revived": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf(playerData.getHasBeenRevived());
            }
            case "health": {
                return String.valueOf((int)(player.getPlayer().getHealth() / 2.0));
            }
            case "maxhearts": {
                Player onlinePlayer = player.getPlayer();
                if (onlinePlayer == null) {
                    return "" + this.plugin.getConfig().getInt("maxHearts") * 2;
                }
                return "" + MaxHeartsManager.getMaxHearts(player.getPlayer(), this.plugin.getConfig());
            }
            case "maxrevives": {
                return String.valueOf(this.plugin.getConfig().getInt("maxRevives"));
            }
            case "craftedhearts": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf(playerData.getCraftedHearts());
            }
            case "craftedrevives": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf(playerData.getCraftedRevives());
            }
            case "isInGracePeriod": {
                GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
                if (!gracePeriodManager.isEnabled()) {
                    return "false";
                }
                return String.valueOf(gracePeriodManager.isInGracePeriod((OfflinePlayer)player.getPlayer()));
            }
            case "gracePeriodRemaining": {
                GracePeriodManager gracePeriodManager = this.plugin.getGracePeriodManager();
                if (!gracePeriodManager.isEnabled()) {
                    return "-1";
                }
                return TimeFormatter.formatDuration(gracePeriodManager.getGracePeriodRemaining(player.getPlayer()).orElse(0).intValue());
            }
            case "heartCooldown": {
                long heartCooldownTime = this.plugin.getConfig().getLong("heartCooldown");
                long now = System.currentTimeMillis();
                long lastHeartUse = CooldownManager.lastHeartUse.getOrDefault(player.getUniqueId(), 0L);
                long timeLeft = lastHeartUse + heartCooldownTime - now;
                return TimeFormatter.formatDuration(timeLeft);
            }
        }
        return "InvalidPlaceholder";
    }
}

