/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.util.customblocks;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;

public enum ParticleColor {
    WHITE(new Bounds(230, 255), new Bounds(230, 255), new Bounds(230, 255)),
    GRAY(new Bounds(100, 155), new Bounds(100, 155), new Bounds(100, 155)),
    RED(new Bounds(200, 255), new Bounds(0, 39), new Bounds(0, 39)),
    ORANGE(new Bounds(230, 255), new Bounds(100, 150), new Bounds(0, 19)),
    YELLOW(new Bounds(230, 255), new Bounds(230, 255), new Bounds(0, 39)),
    GREEN(new Bounds(0, 39), new Bounds(200, 255), new Bounds(0, 39)),
    BLUE(new Bounds(0, 39), new Bounds(0, 39), new Bounds(200, 255)),
    PURPLE(new Bounds(150, 230), new Bounds(0, 39), new Bounds(150, 230)),
    PINK(new Bounds(230, 255), new Bounds(100, 150), new Bounds(150, 230));

    private final Bounds redBounds;
    private final Bounds greenBounds;
    private final Bounds blueBounds;

    private ParticleColor(Bounds redBounds, Bounds greenBounds, Bounds blueBounds) {
        this.redBounds = redBounds;
        this.greenBounds = greenBounds;
        this.blueBounds = blueBounds;
    }

    public Color getColor() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int red = this.redBounds.random(rand);
        int green = this.greenBounds.random(rand);
        int blue = this.blueBounds.random(rand);
        return Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public static ParticleColor fromString(String colorName) {
        try {
            return ParticleColor.valueOf(colorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return WHITE;
        }
    }

    private record Bounds(int min, int max) {
        private Bounds {
            if (min < 0 || max > 255 || min > max) {
                throw new IllegalArgumentException("Color bounds must be in range 0-255 and min \u2264 max");
            }
        }

        public int random(ThreadLocalRandom rand) {
            return rand.nextInt(this.min, this.max + 1);
        }
    }
}

