/*
 * Decompiled with CFR 0.152.
 */
package at.alex.pingintablist.config;

import at.alex.pingintablist.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class Config {
    public static final Properties defaultValues = new Properties();
    public int offsetX;

    public void read() {
        Properties properties = new Properties(defaultValues);
        try {
            FileReader configReader = new FileReader(Constants.configFilePath);
            properties.load(configReader);
            configReader.close();
        }
        catch (FileNotFoundException e) {
            Constants.LOG.info("Generating the config file at: {}", (Object)Constants.configFilePath);
            this.save();
        }
        catch (IOException e) {
            Constants.LOG.error("[FATAL]: Failed to read config file: {}", (Object)Constants.configFilePath);
            throw new RuntimeException(e);
        }
        this.offsetX = Config.parseIntOrDefault(properties.getProperty("textXOffset"), 0);
    }

    private static int parseIntOrDefault(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void save() {
        try {
            File config = new File(Constants.configFilePath);
            boolean existed = config.exists();
            File parentDir = config.getParentFile();
            if (parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileWriter configWriter = new FileWriter(config);
            Config.writeInt(configWriter, "textXOffset", this.offsetX, 0);
            configWriter.close();
            if (!existed) {
                Constants.LOG.info("Created config file at {}", (Object)Constants.configFilePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeInt(FileWriter configWriter, String name, Integer value, Integer defaultValue) throws IOException {
        if (value == null) {
            configWriter.write(name + "=" + defaultValue + "\n");
        } else {
            configWriter.write(name + "=" + value + "\n");
        }
    }

    static {
        defaultValues.setProperty("textXOffset", String.valueOf(0));
    }
}

