/*
 * Decompiled with CFR 0.152.
 */
package at.alex.pingintablist.config;

import at.alex.pingintablist.CommonClass;
import at.alex.pingintablist.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends Screen {
    private final Screen oldScreen;
    private final int entryW = 30;
    private final int defHeight = 25;
    private EditBox offsetXEntry;
    private final Config config = CommonClass.config;

    public ConfigScreen(Component pTitle) {
        super(pTitle);
        this.oldScreen = Minecraft.getInstance().screen;
    }

    protected void init() {
        this.config.read();
        super.init();
        this.offsetXEntry = new EditBox(Minecraft.getInstance().font, this.width / 2 + 50, this.getPosY(0), 30, 25, (Component)Component.literal((String)"Int"));
        this.offsetXEntry.setResponder(string -> {
            Integer number = this.tryParseIntWithLimits((String)string, Integer.MIN_VALUE, Integer.MAX_VALUE);
            if (number != null || string.isEmpty()) {
                this.offsetXEntry.setTextColor(0xE0E0E0);
            } else {
                this.offsetXEntry.setTextColor(0xFF5555);
            }
        });
        this.offsetXEntry.setValue(String.valueOf(this.config.offsetX));
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.width / 2 - 75 - 30, this.getPosY(0), 150, 25, (Component)Component.literal((String)"X Offset"), this.font));
        this.addRenderableWidget((GuiEventListener)this.offsetXEntry);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Save"), button -> this.onClose()).pos(this.width / 2 - 75, this.height - 35).size(150, 20).build());
    }

    public void onClose() {
        super.onClose();
        this.config.offsetX = Integer.parseInt(this.offsetXEntry.getValue());
        this.config.save();
        Minecraft.getInstance().setScreen(this.oldScreen);
    }

    @Nullable
    private Integer tryParseIntWithLimits(String s, int min, int max) {
        if (s.isBlank()) {
            return null;
        }
        try {
            int numb = Integer.parseInt(s);
            if (numb >= min && numb <= max) {
                return numb;
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private int getPosY(int row) {
        return this.height / 3 + 25 * row + 10 * row;
    }
}

