/*
 * Decompiled with CFR 0.152.
 */
package at.alex.pingintablist.mixin;

import at.alex.pingintablist.CommonClass;
import at.alex.pingintablist.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={PlayerTabOverlay.class})
public class PlayerTabOverlayMixin {
    @ModifyConstant(method={"render"}, constant={@Constant(intValue=13)})
    private int modifySpace(int o) {
        return this.getMaxFontSize();
    }

    @Unique
    public int getMaxFontSize() {
        int max = this.getPlayerInfos().stream().map(PlayerInfo::getLatency).mapToInt(v -> v).map(x -> x == 0 ? 999 : x).max().orElse(0);
        return Minecraft.getInstance().font.width(" " + String.valueOf(max == 0 ? "???" : Integer.valueOf(max)) + "ms") + CommonClass.config.offsetX;
    }

    @Overwrite
    public void renderPingIcon(GuiGraphics guiGraphics, int width, int posX, int posY, PlayerInfo playerInfo) {
        String latency = String.valueOf(playerInfo.getLatency());
        int color = 0xAAAAAA;
        if (playerInfo.getLatency() <= 0) {
            latency = "???";
        } else {
            color = playerInfo.getLatency() < 150 ? 0x55FF55 : (playerInfo.getLatency() < 300 ? 16753920 : (playerInfo.getLatency() < 600 ? 0xFF5555 : (playerInfo.getLatency() < 1000 ? 0xAA0000 : 0)));
        }
        String text = latency + "ms";
        RenderUtils.renderScaledText(guiGraphics, text, width, posX + width - Minecraft.getInstance().font.width(latency + "ms") - Minecraft.getInstance().font.width(" ") + 3, posY, color);
    }

    @Shadow
    private List<PlayerInfo> getPlayerInfos() {
        return new ArrayList<PlayerInfo>();
    }
}

