package net.enecske.mob_explosion_griefing.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.enecske.mob_explosion_griefing.MobExplosionGriefingGamerule;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(class_3218.class)
public abstract class ServerWorldMixin {
    @Shadow
    public abstract class_1928 getGameRules();

    @Shadow
    protected abstract class_1927.class_4179 getDestructionType(class_1928.class_4313<class_1928.class_4310> decayRule);

    @ModifyExpressionValue(
            method = "createExplosion",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/world/ServerWorld;getDestructionType(Lnet/minecraft/world/GameRules$Key;)Lnet/minecraft/world/explosion/Explosion$DestructionType;"
            ),
            slice = @Slice(
                    from = @At(
                            value = "FIELD",
                            target = "Lnet/minecraft/world/GameRules;MOB_EXPLOSION_DROP_DECAY:Lnet/minecraft/world/GameRules$Key;"
                    )
            )
    )
    private class_1927.class_4179 modifyMobExplosionGriefing(class_1927.class_4179 original, @Local(argsOnly = true) class_1297 entity) {
        if (!this.getGameRules().getBoolean(GameRules.DO_MOB_GRIEFING)) return Explosion.DestructionType.KEEP;

        return switch (entity) {
            case WitherSkullEntity ignored -> {
                if (this.getGameRules().getBoolean(MobExplosionGriefingGamerule.WITHER_GRIEFING))
                    yield this.getDestructionType(GameRules.MOB_EXPLOSION_DROP_DECAY);
                yield Explosion.DestructionType.KEEP;
            }
            case WitherEntity ignored -> {
                if (this.getGameRules().getBoolean(MobExplosionGriefingGamerule.WITHER_GRIEFING))
                    yield this.getDestructionType(GameRules.MOB_EXPLOSION_DROP_DECAY);
                yield Explosion.DestructionType.KEEP;
            }
            case CreeperEntity ignored -> {
                if (this.getGameRules().getBoolean(MobExplosionGriefingGamerule.CREEPER_GRIEFING) && this.getGameRules().getBoolean(MobExplosionGriefingGamerule.MOB_EXPLOSION_GRIEFING))
                    yield this.getDestructionType(GameRules.MOB_EXPLOSION_DROP_DECAY);
                yield Explosion.DestructionType.KEEP;
            }
            case FireballEntity fireball -> {
                if (fireball.getOwner() instanceof GhastEntity) {
                    if (this.getGameRules().getBoolean(MobExplosionGriefingGamerule.GHAST_GRIEFING) && this.getGameRules().getBoolean(MobExplosionGriefingGamerule.MOB_EXPLOSION_GRIEFING))
                        yield this.getDestructionType(GameRules.MOB_EXPLOSION_DROP_DECAY);
                    yield Explosion.DestructionType.KEEP;
                }
                yield original;
            }
            default -> original;
        };

    }
}
