package eva.scrolltweaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.scrolltweaks.ScrollTweaksClient;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File scrollTweaksConfig;
    public static Gson configGson = new GsonBuilder().setPrettyPrinting().create();

    public static void init() {
        createConfig();
        readFromConfig();
        writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            scrollTweaksConfig = new File(folder, "scrolltweaks.json");
            boolean seemsValid;
            if (scrollTweaksConfig.exists()) {
                try {
                    String scrollTweaksConfigJson = Files.readString(Path.of(scrollTweaksConfig.getPath()));
                    seemsValid = scrollTweaksConfigJson.trim().startsWith("{");
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!scrollTweaksConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    ScrollTweaksClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    scrollTweaksConfig.createNewFile();
                    String json = configGson.toJson(ScrollTweaksConfig.getInstance());
                    FileWriter writer = new FileWriter(scrollTweaksConfig);
                    writer.write(json);
                    writer.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

        }
    }

    public static void readFromConfig() {
        try {
            ScrollTweaksConfig config = configGson.fromJson(new FileReader(scrollTweaksConfig), ScrollTweaksConfig.class);
            ScrollTweaksConfig.getInstance().updateConfigs(config);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }


    public static void writeToConfig() {
        try {
            String json = configGson.toJson(ScrollTweaksConfig.getInstance());
            FileWriter writer = new FileWriter(scrollTweaksConfig, false);
            writer.write(json);
            writer.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}