package eva.scrolltweaks.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import eva.scrolltweaks.events.PlayScrollCallback;
import net.minecraft.class_312;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_312.class)
public class MouseHandlerMixin {
    @ModifyExpressionValue(
            method = "onScroll",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/ScrollWheelHandler;onMouseScroll(DD)Lorg/joml/Vector2i;"
            )
    )
    private Vector2i onScroll(Vector2i original) {
        if (PlayScrollCallback.SCROLL_EVENT.invoker().scroll(original)) return new Vector2i(0, 0);
        return original;
    }
}
