package eva.scrolltweaks.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.scrolltweaks.config.ScrollTweaksConfig.*;

public class ScrollTweaksConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("Scroll Tweaks Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        builder.getOrCreateCategory(class_2561.method_43470("Options"))
                .addEntry(builder.entryBuilder().startBooleanToggle(class_2561.method_43470("Horizontal hotbar cycle:"), !isStopXScrollSlotShift())
                        .setDefaultValue(false)
                        .setSaveConsumer(newValue -> setStopXScrollSlotShift(!newValue))
                        .build()
                )
                .addEntry(builder.entryBuilder().startBooleanToggle(class_2561.method_43470("Mimic bound scroll:"), isBindsActivateBoundScrollAction())
                        .setDefaultValue(false)
                        .setTooltip(class_2561.method_43470("If this is on, your scroll emulation binds\nwill activate what you've bound your scroll\nwheel to."))
                        .setSaveConsumer(ScrollTweaksConfig::setBindsActivateBoundScrollAction)
                        .build()
                ).addEntry(builder.entryBuilder().startBooleanToggle(class_2561.method_43470("Allow slot scrolling through scroll binds:"), isAllowSlotScrollThroughBoundAction())
                        .setDefaultValue(false)
                        .setSaveConsumer(ScrollTweaksConfig::setAllowSlotScrollThroughBoundAction)
                        .build()
                );
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}