package eva.scrolltweaks.mixin.client;

import eva.scrolltweaks.access.ScrollWheelHandlerAccess;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Supplier;
import net.minecraft.class_9928;

import static eva.scrolltweaks.util.ScrollBindsHandler.getFakeXScroll;
import static eva.scrolltweaks.util.ScrollBindsHandler.getFakeYScroll;

@Mixin(class_9928.class)
public class ScrollWheelHandlerMixin implements ScrollWheelHandlerAccess {

    @Unique
    private boolean manual = false;

//    @ModifyExpressionValue(
//            method = "onMouseScroll",
//            at = @At(
//                    value = "FIELD",
//                    target = "Lnet/minecraft/client/ScrollWheelHandler;accumulatedScrollX:D",
//                    opcode = Opcodes.GETFIELD
//            )
//    )
//    private double xScroll(double original) {
//        if (manual) return getFakeXScroll();
//        return original;
//    }
//    @ModifyExpressionValue(
//            method = "onMouseScroll",
//            at = @At(
//                    value = "FIELD",
//                    target = "Lnet/minecraft/client/ScrollWheelHandler;accumulatedScrollY:D",
//                    opcode = Opcodes.GETFIELD
//            )
//    )
//    private double yScroll(double original) {
//        if (manual) return getFakeYScroll();
//        return original;
//    }

    @Inject(
            method = "onMouseScroll",
            at = @At("HEAD"),
            cancellable = true
    )
    private void onMouseScroll(double xOffset, double yOffset, CallbackInfoReturnable<Vector2i> cir) {
        if (isManual()) {
            cir.setReturnValue(new Vector2i((int) getFakeXScroll(), (int) getFakeYScroll()));
            cir.cancel();
        }
    }

    @Unique @Override
    public void run(Supplier<Boolean> supplier) {
        manual = true;
        supplier.get();
        manual = false;
    }

    @Unique @Override
    public boolean isManual() {
        return manual;
    }
}
