package eva.scrolltweaks.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.scrolltweaks.access.ScrollWheelHandlerAccess;
import eva.scrolltweaks.events.PlayScrollCallback;
import org.joml.Vector2i;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Supplier;
import net.minecraft.class_312;

import static eva.scrolltweaks.util.ScrollBindsHandler.getFakeXScroll;
import static eva.scrolltweaks.util.ScrollBindsHandler.getFakeYScroll;

@Mixin(class_312.class)
public class MouseHandlerMixin implements ScrollWheelHandlerAccess {

    @Unique
    private boolean manual = false;

    @Inject(
            method = "onScroll",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z"
            ),
            cancellable = true
    )
    private void onScroll(long windowPointer, double xOffset, double yOffset, CallbackInfo ci, @Local(ordinal = 0) int i, @Local(ordinal = 1) int j) {
        if (PlayScrollCallback.SCROLL_EVENT.invoker().scroll(new Vector2i(i, j))) ci.cancel();
    }

    @ModifyExpressionValue(
            method = "onScroll",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/MouseHandler;accumulatedScrollX:D",
                    opcode = Opcodes.GETFIELD,
                    ordinal = 3
            )
    )
    private double xScroll(double original) {
        if (manual) return getFakeXScroll();
        return original;
    }

    @ModifyExpressionValue(
            method = "onScroll",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/MouseHandler;accumulatedScrollY:D",
                    opcode = Opcodes.GETFIELD,
                    ordinal = 3
            )
    )
    private double yScroll(double original) {
        if (manual) return getFakeYScroll();
        return original;
    }

    @Unique
    @Override
    public void run(Supplier<Boolean> supplier) {
        manual = true;
        supplier.get();
        manual = false;
    }

    @Unique @Override
    public boolean isManual() {
        return manual;
    }
}
