package eva.scrolltweaks;

import eva.scrolltweaks.access.ScrollWheelHandlerAccess;
import eva.scrolltweaks.config.JsonConfigHelper;
import eva.scrolltweaks.mixin.client.access.MouseHandlerAccessor;
import eva.scrolltweaks.util.ScrollBindsHandler;
import eva.scrolltweaks.util.ScrollDirection;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollTweaksClient implements ClientModInitializer {
    public static final String MOD_ID = ScrollTweaksMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_304 fakeScrollUp;
    public static final class_304 fakeScrollDown;
    public static final class_304 fakeScrollLeft;
    public static final class_304 fakeScrollRight;
    public static final class_304 modBind;
    private static final class_2960 fakeScrollLoc = class_2960.method_43902("eva", "scroll_maps");
    private static final class_304.class_11900 fakeScrollCategory = class_304.class_11900.method_74698(fakeScrollLoc);

    private static double fakeXScroll = 0.0;
    private static double fakeYScroll = 0.0;

    public static double getFakeXScroll() {
        return fakeXScroll;
    }

    public static void setFakeXScroll(double fakeXScroll) {
        ScrollTweaksClient.fakeXScroll = fakeXScroll;
    }

    public static double getFakeYScroll() {
        return fakeYScroll;
    }

    public static void setFakeYScroll(double fakeYScroll) {
        ScrollTweaksClient.fakeYScroll = fakeYScroll;
    }

    @Override
    public void onInitializeClient() {
        // This entrypoint is suitable for setting up client-specific logic, such as rendering.
        JsonConfigHelper.init();
        ScrollBindsHandler.register();
    }

    public static void tick() {
        if ((fakeScrollDown.method_1434() || fakeScrollUp.method_1434()) && !(fakeScrollUp.method_1434() && fakeScrollDown.method_1434())) {
            if (fakeScrollUp.method_1436()) setFakeYScroll(1.0d);
            else if (fakeScrollDown.method_1436()) setFakeYScroll(-1.0d);
        } else setFakeYScroll(0.0d);
        if ((fakeScrollLeft.method_1434() || fakeScrollRight.method_1434()) && !(fakeScrollRight.method_1434() && fakeScrollLeft.method_1434())) {
            if (fakeScrollLeft.method_1436()) setFakeXScroll(1.0d);
            else if (fakeScrollRight.method_1436()) setFakeXScroll(-1.0d);
        } else setFakeXScroll(0.0d);
        if (getFakeXScroll() != 0.0d || getFakeYScroll() != 0.0d) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1755 != null)
                minecraft.field_1755.method_25401(
                        ((MouseHandlerAccessor) minecraft.field_1729).getXPos(),
                        ((MouseHandlerAccessor) minecraft.field_1729).getYPos(),
                        getFakeXScroll(),
                        getFakeYScroll()
                );
            else {
                ((ScrollWheelHandlerAccess) ((MouseHandlerAccessor) minecraft.field_1729).getScrollWheelHandler()).run(
                        () -> {
                            ((MouseHandlerAccessor) minecraft.field_1729).invokeOnScroll(
                                    minecraft.method_22683().method_4490(),
                                    ((MouseHandlerAccessor) minecraft.field_1729).getXPos(),
                                    ((MouseHandlerAccessor) minecraft.field_1729).getYPos()
                            );
                            return false;
                        }
                );
            }
        }
    }

    public static void tick2() {
        class_304.method_1416(class_3675.class_307.field_1672.method_1447(ScrollDirection.Up.keyCode), false);
        class_304.method_1416(class_3675.class_307.field_1672.method_1447(ScrollDirection.Down.keyCode), false);
        class_304.method_1416(class_3675.class_307.field_1672.method_1447(ScrollDirection.Left.keyCode), false);
        class_304.method_1416(class_3675.class_307.field_1672.method_1447(ScrollDirection.Right.keyCode), false);
    }

    static {
        fakeScrollUp = KeyBindingHelper.registerKeyBinding(new class_304(
                "Emulate Scroll Up",
                -1,
                fakeScrollCategory
        ));
        fakeScrollDown = KeyBindingHelper.registerKeyBinding(new class_304(
                "Emulate Scroll Down",
                -1,
                fakeScrollCategory
        ));
        fakeScrollLeft = KeyBindingHelper.registerKeyBinding(new class_304(
                "Emulate Scroll Left",
                -1,
                fakeScrollCategory
        ));
        fakeScrollRight = KeyBindingHelper.registerKeyBinding(new class_304(
                "Emulate Scroll Right",
                -1,
                fakeScrollCategory
        ));
        modBind = KeyBindingHelper.registerKeyBinding(new class_304(
                "Modifier",
                -1,
                fakeScrollCategory
        ));
    }
}