package eva.scrolltweaks.config;

public class ScrollTweaksConfig {

    private static ScrollTweaksConfig INSTANCE;

    private boolean stopXScrollSlotShift = true;
    private boolean bindsActivateBoundScrollAction = false;
    private boolean allowSlotScrollThroughBoundAction = false;

    public static ScrollTweaksConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScrollTweaksConfig();
        }
        return INSTANCE;
    }

    public void updateConfigs(ScrollTweaksConfig config) {
        this.stopXScrollSlotShift = config.stopXScrollSlotShift;
        this.bindsActivateBoundScrollAction = config.bindsActivateBoundScrollAction;
        this.allowSlotScrollThroughBoundAction = config.allowSlotScrollThroughBoundAction;
    }

    public static boolean isStopXScrollSlotShift() {
        return getInstance().stopXScrollSlotShift;
    }
    public static void setStopXScrollSlotShift(boolean stopXScrollSlotShift) {
        getInstance().stopXScrollSlotShift = stopXScrollSlotShift;
    }

    public static boolean isBindsActivateBoundScrollAction() {
        return getInstance().bindsActivateBoundScrollAction;
    }

    public static void setBindsActivateBoundScrollAction(boolean bindsActivateBoundScrollAction) {
        getInstance().bindsActivateBoundScrollAction = bindsActivateBoundScrollAction;
    }

    public static boolean isAllowSlotScrollThroughBoundAction() {
        return getInstance().allowSlotScrollThroughBoundAction;
    }

    public static void setAllowSlotScrollThroughBoundAction(boolean allowSlotScrollThroughBoundAction) {
        getInstance().allowSlotScrollThroughBoundAction = allowSlotScrollThroughBoundAction;
    }
}
