package eva.scrolltweaks.events;

import eva.scrolltweaks.ScrollTweaksClient;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import org.joml.Vector2i;

public interface PlayScrollCallback {
/**
 * Callback for scrolling outside a menu screen.
 * Called when any scrolling happens, vertical or horizontal.
 * Upon return:
 * <p>
 * - true cancels vanilla behavior (such as moving through the hotbar), but does not prevent other listeners from running.
 * <p>
 * - false allows hotbar scrolling to occur as normal.
 **/
    Event<PlayScrollCallback> SCROLL_EVENT = EventFactory.createArrayBacked(PlayScrollCallback.class,
            (listeners) -> (vector) -> {
        boolean bl = false;
        if (ScrollTweaksClient.modBind.method_1434()) vector = new Vector2i(vector.y(), 0);
        for (PlayScrollCallback listener : listeners) {
            bl |= listener.scroll(vector);
        }
        return bl;
    });

    boolean scroll(Vector2i vec);
}
