package eva.scrolltweaks.util;

public enum ScrollDirection {
    Up( -2, Direction.Pos),
    Down(-3, Direction.Neg),
    Left(-4, Direction.Pos),
    Right(-5, Direction.Neg),;

    public final int keyCode;
    public final Direction dir;
    ScrollDirection(int keyCode, Direction dir) {
        this.keyCode = keyCode;
        this.dir = dir;
    }

    public static ScrollDirection parse(double x, double y) {
        Direction dir;
        Axis ax;
        double placeHolder;
        if (Math.abs(x) < Math.abs(y)) {
            ax = Axis.V;
            placeHolder = y;
        }
        else {
            ax = Axis.H;
            placeHolder = x;
        }
        dir = Direction.parse(placeHolder);
        return ax.get(dir);
    }

//    public static ScrollDirection[] biParse(double x, double y) {
//
//    }

    public enum Axis {
        V(ScrollDirection.Down, ScrollDirection.Up),
        H(ScrollDirection.Right, ScrollDirection.Left),;

        private final ScrollDirection pos;
        private final ScrollDirection neg;

        Axis(ScrollDirection neg, ScrollDirection pos) {
            this.pos = pos;
            this.neg = neg;
        }

        ScrollDirection getNeg() {
            return get(Direction.Neg);
        }
        ScrollDirection getPos() {
            return get(Direction.Pos);
        }

        ScrollDirection get(Direction dir) {
            return switch (dir) {
                case Pos -> this.pos;
                case Neg -> this.neg;
            };
        }
    }
    public enum Direction {
        Neg,
        Pos;
        static Direction parse(double d) {
            if (d > 0) return Pos;
            return Neg;
        }
    }
}
