/*
 * Decompiled with CFR 0.152.
 */
package eva.scrolltweaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.scrolltweaks.ScrollTweaksClient;
import eva.scrolltweaks.config.ScrollTweaksConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File scrollTweaksConfig;
    public static Gson configGson;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            scrollTweaksConfig = new File(folder, "scrolltweaks.json");
            if (scrollTweaksConfig.exists()) {
                try {
                    String scrollTweaksConfigJson = Files.readString(Path.of(scrollTweaksConfig.getPath(), new String[0]));
                    seemsValid = scrollTweaksConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!scrollTweaksConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    ScrollTweaksClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    scrollTweaksConfig.createNewFile();
                    String json = configGson.toJson((Object)ScrollTweaksConfig.getInstance());
                    FileWriter writer = new FileWriter(scrollTweaksConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            ScrollTweaksConfig config = (ScrollTweaksConfig)configGson.fromJson((Reader)new FileReader(scrollTweaksConfig), ScrollTweaksConfig.class);
            ScrollTweaksConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)ScrollTweaksConfig.getInstance());
            FileWriter writer = new FileWriter(scrollTweaksConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

