/*
 * Decompiled with CFR 0.152.
 */
package eva.scrolltweaks.util;

public enum ScrollDirection {
    Up(-2, Direction.Pos),
    Down(-3, Direction.Neg),
    Left(-4, Direction.Pos),
    Right(-5, Direction.Neg);

    public final int keyCode;
    public final Direction dir;

    private ScrollDirection(int keyCode, Direction dir) {
        this.keyCode = keyCode;
        this.dir = dir;
    }

    public static ScrollDirection parse(double x, double y) {
        double placeHolder;
        Axis ax;
        if (Math.abs(x) < Math.abs(y)) {
            ax = Axis.V;
            placeHolder = y;
        } else {
            ax = Axis.H;
            placeHolder = x;
        }
        Direction dir = Direction.parse(placeHolder);
        return ax.get(dir);
    }

    public static enum Direction {
        Neg,
        Pos;


        static Direction parse(double d) {
            if (d > 0.0) {
                return Pos;
            }
            return Neg;
        }
    }

    public static enum Axis {
        V(Down, Up),
        H(Right, Left);

        private final ScrollDirection pos;
        private final ScrollDirection neg;

        private Axis(ScrollDirection neg, ScrollDirection pos) {
            this.pos = pos;
            this.neg = neg;
        }

        ScrollDirection getNeg() {
            return this.get(Direction.Neg);
        }

        ScrollDirection getPos() {
            return this.get(Direction.Pos);
        }

        ScrollDirection get(Direction dir) {
            return switch (dir.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> this.pos;
                case 0 -> this.neg;
            };
        }
    }
}

