/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.dented.downloadingdiscs.block.ModBlocks;
import net.dented.downloadingdiscs.block.entity.ModBlockEntities;
import net.dented.downloadingdiscs.component.ModDataComponentTypes;
import net.dented.downloadingdiscs.config.Config;
import net.dented.downloadingdiscs.event.ModServerEvents;
import net.dented.downloadingdiscs.item.ModItemGroups;
import net.dented.downloadingdiscs.network.ModNetworkRegistry;
import net.dented.downloadingdiscs.network.ReplaceTitleC2SPacket;
import net.dented.downloadingdiscs.network.ReplaceUrlC2SPacket;
import net.dented.downloadingdiscs.network.ValidateDiscC2SPacket;
import net.dented.downloadingdiscs.screen.ModScreenHandlers;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadingDiscsMod
implements ModInitializer {
    public static final String MOD_ID = "downloadingdiscs";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"downloadingdiscs");

    public void onInitialize() {
        DownloadingDiscsMod.loadConfig();
        ModServerEvents.registerModServerEvents();
        ModDataComponentTypes.registerModDataComponentTypes();
        ModScreenHandlers.registerScreenHandlers();
        ModBlocks.registerModBlocks();
        ModItemGroups.addModItemsToVanillaItemGroups();
        ModNetworkRegistry.registerNetworkHandling();
        ServerPlayNetworking.registerGlobalReceiver(ReplaceUrlC2SPacket.ID, ReplaceUrlC2SPacket::handlePacket);
        ServerPlayNetworking.registerGlobalReceiver(ReplaceTitleC2SPacket.ID, ReplaceTitleC2SPacket::handlePacket);
        ServerPlayNetworking.registerGlobalReceiver(ValidateDiscC2SPacket.ID, ValidateDiscC2SPacket::handlePacket);
        ModBlockEntities.registerModBlockEntities();
    }

    public static void loadConfig() {
        Path configPath = Config.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            Config.loadConfigFromFile();
        }
        Config.writeConfigToFile();
    }
}

