/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.apps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.SystemUtils;

public class FFMpegApp {
    private static final String FILE_NAME = "ffmpeg";
    private static final String REPOSITORY_NAME = "eugeneware/ffmpeg-static";
    private static final String REPOSITORY_FILE = String.format("ffmpeg-%s-x64", SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_MAC ? "darwin" : "win32"));
    private static Path FILE_PATH;
    public Path DIRECTORY = FabricLoader.getInstance().getGameDir().resolve("apps");
    private static final ConcurrentHashMap<String, FFMpegAppStream> activeFFMpegProcesses;

    public FFMpegApp() {
        FILE_PATH = this.DIRECTORY.resolve(FILE_NAME + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
    }

    public static Path getDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve("apps");
    }

    public boolean registerProcess(String id, FFMpegAppStream processStream) {
        return activeFFMpegProcesses.computeIfAbsent(id, k -> {
            processStream.onExit(() -> activeFFMpegProcesses.remove(id));
            return processStream;
        }) == processStream;
    }

    public void killProcess(String id) {
        FFMpegAppStream stream = activeFFMpegProcesses.remove(id);
        if (stream != null && stream.process != null) {
            try {
                stream.process.descendants().forEach(ph -> {
                    ph.destroyForcibly();
                    ph.onExit().join();
                });
                stream.process.destroyForcibly();
                stream.process.onExit().join();
            }
            catch (Exception e) {
                DownloadingDiscsMod.LOGGER.error("Failed to kill process with ID: {}", (Object)id, (Object)e);
            }
        }
    }

    public boolean checkForApplication() {
        DownloadingDiscsMod.LOGGER.info("Checking for ffmpeg");
        if (this.DIRECTORY.toFile().exists() || this.DIRECTORY.toFile().mkdirs()) {
            if (!FILE_PATH.toFile().exists()) {
                return FFMpegApp.downloadApplication();
            }
            return true;
        }
        return false;
    }

    private static boolean downloadApplication() {
        boolean bl;
        block18: {
            InputStream inputStream = FFMpegApp.getDownloadInputStream();
            try {
                if (REPOSITORY_FILE.endsWith(".zip")) {
                    try (ZipInputStream zipInput = new ZipInputStream(inputStream);){
                        ZipEntry zipEntry = zipInput.getNextEntry();
                        while (zipEntry != null) {
                            if (zipEntry.getName().endsWith(FILE_NAME + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))) {
                                Files.copy(zipInput, FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                            }
                            zipEntry = zipInput.getNextEntry();
                        }
                    }
                } else {
                    Files.copy(inputStream, FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                    DownloadingDiscsMod.LOGGER.warn("Downloading application " + REPOSITORY_FILE);
                }
                if (SystemUtils.IS_OS_UNIX) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", FILE_PATH.toString()});
                }
                bl = true;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private static InputStream getDownloadInputStream() throws IOException, URISyntaxException {
        String url = String.format("https://github.com/%s/releases/latest/download/%s", REPOSITORY_NAME, REPOSITORY_FILE);
        return new URI(url).toURL().openStream();
    }

    static {
        activeFFMpegProcesses = new ConcurrentHashMap();
    }

    public class FFMpegAppStream {
        private final String id;
        private final String[] arguments;
        private final SubmissionPublisher<String> publisher = new SubmissionPublisher();
        private final ConcurrentHashMap<String, Flow.Subscription> subscriptions = new ConcurrentHashMap();
        private Process process;

        public FFMpegAppStream(String id, String ... arguments) {
            this.id = id;
            this.arguments = arguments;
            if (FFMpegApp.this.registerProcess(id, this)) {
                CompletableFuture.runAsync(this::startProcess);
            }
        }

        public void unsubscribe(String subscriberId) {
            Flow.Subscription subscription = this.subscriptions.remove(subscriberId);
            if (subscription != null) {
                subscription.cancel();
            }
        }

        public void onExit(Runnable callback) {
            if (this.process != null) {
                this.process.onExit().thenRun(() -> {
                    ((ConcurrentHashMap.KeySetView)this.subscriptions.keySet()).forEach(this::unsubscribe);
                    callback.run();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startProcess() {
            try {
                this.process = new ProcessBuilder(new String[0]).command((String[])Stream.concat(Stream.of(FILE_PATH.toString()), Stream.of(this.arguments)).toArray(String[]::new)).redirectErrorStream(true).start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null && !this.publisher.isClosed()) {
                        this.publisher.submit(line);
                    }
                }
                int exitCode = this.process.waitFor();
                if (exitCode == 0) {
                    this.publisher.close();
                } else {
                    this.publisher.closeExceptionally(new IOException("Process failed with code: " + exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                this.publisher.closeExceptionally(e);
            }
            finally {
                FFMpegApp.this.killProcess(this.id);
            }
        }
    }
}

