/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.dented.downloadingdiscs.config.DiscWriterOutputOption;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static DiscWriterOutputOption discWriterOutput = DiscWriterOutputOption.ON_COMPLETE;
    public static int discWriterMinimumPermissionLevel = 0;
    public static int downloadedAudioBitrateKbps = 192;
    public static int connectionAttemptTimeoutSeconds = 10;
    public static int downloadTimeoutMinutes = 5;
    public static int discWriterUrlCharacterLimit = 200;
    public static int discWriterTitleCharacterLimit = 50;
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("downloadingdiscs.json");
    }

    public static void loadConfigFromFile() {
        Path configPath = Config.getConfigPath();
        try {
            GSON.fromJson(Files.readString(configPath), Config.class);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.warn("Failed to read config file from " + String.valueOf(configPath), (Throwable)e);
        }
    }

    public static void writeConfigToFile() {
        Path configPath = Config.getConfigPath();
        try {
            String jsonString = GSON.toJson((Object)new Config());
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.warn("Failed to write config file to " + String.valueOf(configPath), (Throwable)e);
        }
    }
}

