/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.screen.custom;

import java.util.Collections;
import java.util.LinkedHashSet;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.dented.downloadingdiscs.block.entity.custom.DiscWriterBlockEntity;
import net.dented.downloadingdiscs.component.DiscUrlComponent;
import net.dented.downloadingdiscs.component.ModDataComponentTypes;
import net.dented.downloadingdiscs.config.Config;
import net.dented.downloadingdiscs.screen.ModScreenHandlers;
import net.dented.downloadingdiscs.util.DiscValidator;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class DiscWriterScreenHandler
extends class_1703 {
    public String newUrl;
    public String newTitle;
    public class_1799 outputStack;
    private final class_1263 inventory;
    private final class_1661 playerInventory;
    public final DiscWriterBlockEntity discWriterBlockEntity;
    private class_3218 serverWorld;

    public DiscWriterScreenHandler(int syncId, class_1661 inventory, class_2338 blockPos) {
        this(syncId, inventory, inventory.field_7546.method_37908().method_8321(blockPos), (class_3913)new class_3919(1));
    }

    public DiscWriterScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity, class_3913 arrayPropertyDelegate) {
        super(ModScreenHandlers.DISC_WRITER_SCREEN_HANDLER, syncId);
        this.inventory = (class_1263)blockEntity;
        this.playerInventory = playerInventory;
        this.discWriterBlockEntity = (DiscWriterBlockEntity)blockEntity;
        this.discWriterBlockEntity.setInUse(true);
        this.discWriterBlockEntity.setUser(this.playerInventory.field_7546);
        if (!this.playerInventory.field_7546.method_37908().method_8608()) {
            this.serverWorld = (class_3218)playerInventory.field_7546.method_37908();
        }
        this.method_7621(new class_1735(this.inventory, 0, 84, 50){

            public boolean method_7680(class_1799 stack) {
                return stack.method_57826(class_9334.field_52175) && this.field_7871.method_5438(2).method_7960() && this.field_7871.method_5438(1).method_7960();
            }

            public boolean method_7674(class_1657 playerEntity) {
                return DiscWriterScreenHandler.this.discWriterBlockEntity.propertyDelegate.method_17390(0) < 2;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                super.method_7667(player, stack);
                DiscWriterScreenHandler.this.discWriterBlockEntity.propertyDelegate.method_17391(0, 0);
                DiscWriterScreenHandler.this.clearOutputStack();
            }

            public void method_7670(class_1799 newItem, class_1799 original) {
                super.method_7670(newItem, original);
                DiscWriterScreenHandler.this.discWriterBlockEntity.propertyDelegate.method_17391(0, 0);
                DiscWriterScreenHandler.this.clearOutputStack();
            }
        });
        this.method_7621(new class_1735(this.inventory, 1, 142, 50){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return this.method_7681();
            }

            public boolean method_51306() {
                return this.method_7681();
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                super.method_7667(player, stack);
                DiscWriterScreenHandler.this.discWriterBlockEntity.propertyDelegate.method_17391(0, 0);
                player.method_37908().method_8396((class_1297)player, DiscWriterScreenHandler.this.discWriterBlockEntity.method_11016(), class_3417.field_17481, class_3419.field_15245, 1.0f, -2.0f);
                DiscWriterScreenHandler.this.clearOutputStack();
            }

            public void method_7670(class_1799 newItem, class_1799 original) {
                super.method_7670(newItem, original);
                DiscWriterScreenHandler.this.discWriterBlockEntity.propertyDelegate.method_17391(0, 0);
                DiscWriterScreenHandler.this.discWriterBlockEntity.method_10997().method_8396(null, DiscWriterScreenHandler.this.discWriterBlockEntity.method_11016(), class_3417.field_17481, class_3419.field_15245, 1.0f, -2.0f);
                DiscWriterScreenHandler.this.clearOutputStack();
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 2, 113, 50){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_51306() {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return false;
            }
        });
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.method_17360(arrayPropertyDelegate);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot == 0) {
                slot.method_7667(this.playerInventory.field_7546, originalStack);
                if (!this.method_7616(originalStack, 3, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (invSlot == 1) {
                slot.method_7667(this.playerInventory.field_7546, originalStack);
                if (!this.method_7616(originalStack, 3, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        if (inventory == this.inventory) {
            // empty if block
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.discWriterBlockEntity.setInUse(false);
        this.discWriterBlockEntity.setUser(null);
    }

    public void method_7606(int id, int value) {
        super.method_7606(id, value);
        this.method_7623();
    }

    public void startValidationAsync() {
        String finalUrl = this.newUrl == null || this.newUrl.isBlank() ? (this.outputStack.method_58694(ModDataComponentTypes.DISC_URL) instanceof DiscUrlComponent ? ((DiscUrlComponent)this.outputStack.method_58694(ModDataComponentTypes.DISC_URL)).url() : "[empty]") : this.newUrl;
        Thread thread = new Thread(() -> {
            try {
                DownloadingDiscsMod.LOGGER.warn(this.playerInventory.field_7546.method_5820() + " initiated validation for URL '" + finalUrl + "'");
                this.validateDisc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void validateDisc() {
        class_1657 player = this.playerInventory.field_7546;
        if (!player.method_37908().method_8608()) {
            if (this.outputStack == null || this.outputStack.method_7960()) {
                this.outputStack = this.inventory.method_5438(0).method_7972();
            }
            this.inventory.method_5447(2, this.outputStack);
            this.inventory.method_5447(0, class_1799.field_8037);
            this.method_7623();
            DiscValidator validator = new DiscValidator(this.serverWorld, player, this.outputStack, this.newUrl, Config.discWriterOutput);
            boolean validated = validator.validate();
            if (validated) {
                this.inventory.method_5447(2, class_1799.field_8037);
                this.inventory.method_5447(1, this.outputStack);
                this.serverWorld.method_8396(null, this.discWriterBlockEntity.method_11016(), class_3417.field_17484, class_3419.field_15245, 1.0f, -2.0f);
                this.discWriterBlockEntity.propertyDelegate.method_17391(0, 3);
            } else {
                this.eraseDiscMetadata(this.outputStack);
                this.inventory.method_5447(1, this.outputStack);
                this.inventory.method_5447(2, class_1799.field_8037);
                this.serverWorld.method_8396(null, this.discWriterBlockEntity.method_11016(), class_3417.field_17484, class_3419.field_15245, 1.0f, -2.0f);
                this.discWriterBlockEntity.propertyDelegate.method_17391(0, 4);
            }
        }
        this.clearOutputStack();
        this.method_7623();
    }

    private void eraseDiscMetadata(class_1799 stack) {
        class_9279 customDataToErase = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 erasedTag = customDataToErase.method_57461();
        if (erasedTag.method_10545("CustomSound")) {
            erasedTag.method_10551("CustomSound");
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)erasedTag));
        }
        stack.method_57381(ModDataComponentTypes.DISC_URL);
        stack.method_57381(class_9334.field_49632);
        stack.method_57379(class_9334.field_56400, (Object)class_10712.field_56318);
    }

    public void updateOutputStack() {
        if (!this.inventory.method_5438(0).method_7960()) {
            if (this.newUrl == null) {
                this.newUrl = "";
            }
            if (this.newTitle == null) {
                this.newTitle = "";
            }
            if (this.outputStack == null || this.outputStack.method_7960()) {
                this.outputStack = this.inventory.method_5438(0).method_7972();
            }
            class_1799 itemStack = this.outputStack.method_7972();
            if (this.newUrl.isBlank() && this.outputStack.method_58694(ModDataComponentTypes.DISC_URL) instanceof DiscUrlComponent) {
                itemStack.method_57381(ModDataComponentTypes.DISC_URL);
                itemStack.method_57381(class_9334.field_49632);
                itemStack.method_57379(class_9334.field_56400, (Object)class_10712.field_56318);
            } else if (this.newUrl.isBlank()) {
                itemStack = class_1799.field_8037;
            } else {
                itemStack.method_57379(ModDataComponentTypes.DISC_URL, (Object)new DiscUrlComponent(this.newUrl));
                class_10712 tooltipDisplay = (class_10712)itemStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
                LinkedHashSet<class_9331> hiddenComponents = new LinkedHashSet<class_9331>(tooltipDisplay.comp_3601());
                hiddenComponents.add(class_9334.field_52175);
                itemStack.method_57379(class_9334.field_56400, (Object)new class_10712(tooltipDisplay.comp_3600(), hiddenComponents));
            }
            if (this.newTitle.isBlank()) {
                class_9290 loreComponent = new class_9290(Collections.singletonList(class_2561.method_43469((String)"container.downloadingdiscs.disc_writer.no_title", (Object[])new Object[]{this.playerInventory.field_7546.method_5820()}).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
                itemStack.method_57379(class_9334.field_49632, (Object)loreComponent);
            } else {
                itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(Collections.singletonList(class_2561.method_43470((String)this.newTitle).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080))));
            }
            this.outputStack = itemStack;
            this.method_7623();
        }
    }

    public boolean setUrl(String url) {
        String string = url;
        if (string != null) {
            this.newUrl = string;
            this.updateOutputStack();
            return true;
        }
        return false;
    }

    public boolean setTitle(String title) {
        String string = title;
        if (string != null) {
            this.newTitle = string;
            this.updateOutputStack();
            return true;
        }
        return false;
    }

    public void clearOutputStack() {
        this.newUrl = null;
        this.newTitle = null;
        this.outputStack = null;
    }
}

