/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class DownloadableAudioMap {
    private Map<UUID, String> downloadedAudioMap = new HashMap<UUID, String>();

    public boolean isURLPresent(String url) {
        return this.downloadedAudioMap.containsValue(url);
    }

    public void clearMap() {
        this.downloadedAudioMap.clear();
    }

    public void addAttemptedURL(UUID uuid, String url) {
        this.downloadedAudioMap.put(uuid, url);
    }

    public void removeDownloadedAudio(UUID uuid) {
        this.downloadedAudioMap.remove(uuid);
    }

    public String getURLfromUUID(UUID uuid) {
        return this.downloadedAudioMap.get(uuid);
    }

    public UUID getUUIDfromURL(String url) {
        for (Map.Entry<UUID, String> entry : this.downloadedAudioMap.entrySet()) {
            if (!Objects.equals(entry.getValue(), url)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<UUID, String> getMap() {
        return this.downloadedAudioMap;
    }

    public void setMap(Map<UUID, String> newMap) {
        this.downloadedAudioMap = new HashMap<UUID, String>(newMap);
    }

    public String toString() {
        return this.downloadedAudioMap.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }
}

