/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.dented.downloadingdiscs.util.DownloadableAudioMap;
import net.minecraft.class_3218;
import net.minecraft.class_5218;

public class DownloadableAudioMapManager {
    private static DownloadableAudioMap INSTANCE = new DownloadableAudioMap();
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static boolean isURLPresent(String url) {
        return INSTANCE.isURLPresent(url);
    }

    public static void clearMap() {
        INSTANCE.clearMap();
    }

    public static void addAttemptedURL(UUID uuid, String url) {
        INSTANCE.addAttemptedURL(uuid, url);
    }

    public static void removeDownloadedAudio(UUID uuid) {
        INSTANCE.removeDownloadedAudio(uuid);
    }

    public static String getURLfromUUID(UUID uuid) {
        return INSTANCE.getURLfromUUID(uuid);
    }

    public static UUID getUUIDfromURL(String url) {
        return INSTANCE.getUUIDfromURL(url);
    }

    public static DownloadableAudioMap getInstance() {
        return INSTANCE;
    }

    public static Path getMapPath(class_3218 serverWorld) {
        String path = String.valueOf(serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")));
        File directory = new File(path);
        directory.mkdir();
        return serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")).resolve("downloaded_audio_map.json");
    }

    public static void loadMapFromFile(class_3218 serverWorld) {
        Path mapPath = DownloadableAudioMapManager.getMapPath(serverWorld);
        try {
            if (Files.exists(mapPath, new LinkOption[0])) {
                DownloadableAudioMap loaded = (DownloadableAudioMap)GSON.fromJson(Files.readString(mapPath), DownloadableAudioMap.class);
                if (loaded != null) {
                    INSTANCE.setMap(loaded.getMap());
                } else {
                    INSTANCE.clearMap();
                }
            } else {
                INSTANCE.clearMap();
            }
        }
        catch (IOException e) {
            INSTANCE.clearMap();
            DownloadingDiscsMod.LOGGER.warn("Failed to read map file from " + String.valueOf(mapPath));
            e.printStackTrace();
        }
    }

    public static void writeMapToFile(class_3218 serverWorld) {
        Path mapPath = DownloadableAudioMapManager.getMapPath(serverWorld);
        try {
            String jsonString = GSON.toJson((Object)INSTANCE);
            Files.writeString(mapPath, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.warn("Failed to write map file to " + String.valueOf(mapPath));
            e.printStackTrace();
        }
    }
}

