/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.apps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.SystemUtils;

public class FFProbeApp {
    private final String FILE_NAME = "ffprobe";
    private final String REPOSITORY_NAME = "eugeneware/ffmpeg-static";
    private final String REPOSITORY_FILE = String.format("ffprobe-%s-x64", SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_MAC ? "darwin" : "win32"));
    private final Path FILE_PATH;
    public Path DIRECTORY = FabricLoader.getInstance().getGameDir().resolve("apps");
    private static final ConcurrentHashMap<String, FFProbeAppStream> activeFFProbeProcesses = new ConcurrentHashMap();

    public FFProbeApp() {
        this.FILE_PATH = this.DIRECTORY.resolve("ffprobe" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
    }

    public boolean registerProcess(String id, FFProbeAppStream processStream) {
        return activeFFProbeProcesses.computeIfAbsent(id, k -> {
            processStream.onExit(() -> activeFFProbeProcesses.remove(id));
            return processStream;
        }) == processStream;
    }

    public void killProcess(String id) {
        FFProbeAppStream stream = activeFFProbeProcesses.remove(id);
        if (stream != null && stream.process != null) {
            try {
                stream.process.descendants().forEach(ph -> {
                    ph.destroyForcibly();
                    ph.onExit().join();
                });
                stream.process.destroyForcibly();
                stream.process.onExit().join();
            }
            catch (Exception e) {
                DownloadingDiscsMod.LOGGER.error("Failed to kill process with ID: {}", (Object)id, (Object)e);
            }
        }
    }

    public boolean checkForApplication() {
        DownloadingDiscsMod.LOGGER.info("Checking for ffprobe");
        if (this.DIRECTORY.toFile().exists() || this.DIRECTORY.toFile().mkdirs()) {
            if (!this.FILE_PATH.toFile().exists()) {
                return this.downloadApplication();
            }
            return true;
        }
        return false;
    }

    private boolean downloadApplication() {
        boolean bl;
        block18: {
            InputStream inputStream = this.getDownloadInputStream();
            try {
                if (this.REPOSITORY_FILE.endsWith(".zip")) {
                    try (ZipInputStream zipInput = new ZipInputStream(inputStream);){
                        ZipEntry zipEntry = zipInput.getNextEntry();
                        while (zipEntry != null) {
                            if (zipEntry.getName().endsWith("ffprobe" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))) {
                                Files.copy(zipInput, this.FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                            }
                            zipEntry = zipInput.getNextEntry();
                        }
                    }
                } else {
                    Files.copy(inputStream, this.FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                    DownloadingDiscsMod.LOGGER.warn("Downloading application " + this.REPOSITORY_FILE);
                }
                if (SystemUtils.IS_OS_UNIX) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", this.FILE_PATH.toString()});
                }
                bl = true;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private InputStream getDownloadInputStream() throws IOException, URISyntaxException {
        String url = String.format("https://github.com/%s/releases/latest/download/%s", "eugeneware/ffmpeg-static", this.REPOSITORY_FILE);
        return new URI(url).toURL().openStream();
    }

    public class FFProbeAppStream {
        private final String id;
        private final String[] arguments;
        private final SubmissionPublisher<String> publisher = new SubmissionPublisher();
        private final ConcurrentHashMap<String, Flow.Subscription> subscriptions = new ConcurrentHashMap();
        private Process process;

        public FFProbeAppStream(String id, String ... arguments) {
            this.id = id;
            this.arguments = arguments;
            if (FFProbeApp.this.registerProcess(id, this)) {
                CompletableFuture.runAsync(this::startProcess);
            }
        }

        public void unsubscribe(String subscriberId) {
            Flow.Subscription subscription = this.subscriptions.remove(subscriberId);
            if (subscription != null) {
                subscription.cancel();
            }
        }

        public void onExit(Runnable callback) {
            if (this.process != null) {
                this.process.onExit().thenRun(() -> {
                    ((ConcurrentHashMap.KeySetView)this.subscriptions.keySet()).forEach(this::unsubscribe);
                    callback.run();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startProcess() {
            try {
                this.process = new ProcessBuilder(new String[0]).command((String[])Stream.concat(Stream.of(FFProbeApp.this.FILE_PATH.toString()), Stream.of(this.arguments)).toArray(String[]::new)).redirectErrorStream(true).start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null && !this.publisher.isClosed()) {
                        this.publisher.submit(line);
                    }
                }
                int exitCode = this.process.waitFor();
                if (exitCode == 0) {
                    this.publisher.close();
                } else {
                    this.publisher.closeExceptionally(new IOException("Process failed with code: " + exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                this.publisher.closeExceptionally(e);
            }
            finally {
                FFProbeApp.this.killProcess(this.id);
            }
        }
    }
}

