/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.apps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.SystemUtils;

public class YTDLPApp {
    private final String FILE_NAME = "yt-dlp";
    private final String REPOSITORY_NAME = "yt-dlp/yt-dlp";
    private final String REPOSITORY_FILE = String.format("yt-dlp%s", SystemUtils.IS_OS_LINUX ? "_linux" : (SystemUtils.IS_OS_MAC ? "_macos" : ".exe"));
    private static Path FILE_PATH;
    public static Path DIRECTORY;
    private static final ConcurrentHashMap<String, YTDLPAppStream> activeYTDLPProcesses;

    public YTDLPApp() {
        DIRECTORY = FabricLoader.getInstance().getGameDir().resolve("apps");
        FILE_PATH = DIRECTORY.resolve("yt-dlp" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
    }

    public static boolean registerProcess(String id, YTDLPAppStream processStream) {
        return activeYTDLPProcesses.computeIfAbsent(id, k -> {
            processStream.onExit(() -> activeYTDLPProcesses.remove(id));
            return processStream;
        }) == processStream;
    }

    public static void killProcess(String id) {
        YTDLPAppStream stream = activeYTDLPProcesses.remove(id);
        if (stream != null && stream.process != null) {
            try {
                stream.process.descendants().forEach(ph -> {
                    ph.destroyForcibly();
                    ph.onExit().join();
                });
                stream.process.destroyForcibly();
                stream.process.onExit().join();
            }
            catch (Exception e) {
                DownloadingDiscsMod.LOGGER.error("Failed to kill process with ID: {}", (Object)id, (Object)e);
            }
        }
    }

    public boolean checkForApplication() {
        DownloadingDiscsMod.LOGGER.info("Checking for yt-dlp");
        if (DIRECTORY.toFile().exists() || DIRECTORY.toFile().mkdirs()) {
            if (!FILE_PATH.toFile().exists()) {
                return this.downloadApplication();
            }
            return true;
        }
        return false;
    }

    private boolean downloadApplication() {
        boolean bl;
        block18: {
            InputStream inputStream = this.getDownloadInputStream();
            try {
                if (this.REPOSITORY_FILE.endsWith(".zip")) {
                    try (ZipInputStream zipInput = new ZipInputStream(inputStream);){
                        ZipEntry zipEntry = zipInput.getNextEntry();
                        while (zipEntry != null) {
                            if (zipEntry.getName().endsWith("yt-dlp" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))) {
                                Files.copy(zipInput, FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                            }
                            zipEntry = zipInput.getNextEntry();
                        }
                    }
                } else {
                    Files.copy(inputStream, FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
                    DownloadingDiscsMod.LOGGER.warn("Downloading application " + this.REPOSITORY_FILE);
                }
                if (SystemUtils.IS_OS_UNIX) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", FILE_PATH.toString()});
                }
                bl = true;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    private InputStream getDownloadInputStream() throws IOException, URISyntaxException {
        String url = String.format("https://github.com/%s/releases/latest/download/%s", "yt-dlp/yt-dlp", this.REPOSITORY_FILE);
        return new URI(url).toURL().openStream();
    }

    public YTDLPAppStream executeCommand(String id, String ... arguments) {
        return new YTDLPAppStream(id, arguments);
    }

    static {
        activeYTDLPProcesses = new ConcurrentHashMap();
    }

    public static class YTDLPAppStream {
        private final String id;
        private final String[] arguments;
        private final SubmissionPublisher<String> publisher = new SubmissionPublisher();
        private final ConcurrentHashMap<String, Flow.Subscription> subscriptions = new ConcurrentHashMap();
        private Process process;

        public YTDLPAppStream(String id, String ... arguments) {
            this.id = id;
            this.arguments = arguments;
            if (YTDLPApp.registerProcess(id, this)) {
                CompletableFuture.runAsync(this::startProcess);
            }
        }

        public YTDLPSubscriptionBuilder subscribe(String subscriberId) {
            return new YTDLPSubscriptionBuilder(subscriberId);
        }

        public void unsubscribe(String subscriberId) {
            Flow.Subscription subscription = this.subscriptions.remove(subscriberId);
            if (subscription != null) {
                subscription.cancel();
            }
        }

        public void onExit(Runnable callback) {
            if (this.process != null) {
                this.process.onExit().thenRun(() -> {
                    ((ConcurrentHashMap.KeySetView)this.subscriptions.keySet()).forEach(this::unsubscribe);
                    callback.run();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startProcess() {
            try {
                this.process = new ProcessBuilder(new String[0]).command((String[])Stream.concat(Stream.of(FILE_PATH.toString()), Stream.of(this.arguments)).toArray(String[]::new)).redirectErrorStream(true).start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null && !this.publisher.isClosed()) {
                        this.publisher.submit(line);
                    }
                }
                int exitCode = this.process.waitFor();
                if (exitCode == 0) {
                    this.publisher.close();
                } else {
                    this.publisher.closeExceptionally(new IOException("Process failed with code: " + exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                this.publisher.closeExceptionally(e);
            }
            finally {
                YTDLPApp.killProcess(this.id);
            }
        }

        public class YTDLPSubscriptionBuilder {
            private final String subscriberId;
            private Consumer<String> onOutput = s -> {};
            private Consumer<Throwable> onError = t -> {};
            private Runnable onComplete = () -> {};

            public YTDLPSubscriptionBuilder(String subscriberId) {
                this.subscriberId = subscriberId;
            }

            public YTDLPSubscriptionBuilder onOutput(Consumer<String> consumer) {
                this.onOutput = consumer;
                return this;
            }

            public YTDLPSubscriptionBuilder onError(Consumer<Throwable> consumer) {
                this.onError = consumer;
                return this;
            }

            public YTDLPSubscriptionBuilder onComplete(Runnable runnable) {
                this.onComplete = runnable;
                return this;
            }

            public void start() {
                YTDLPAppStream.this.publisher.subscribe(new Flow.Subscriber<String>(){

                    @Override
                    public void onSubscribe(Flow.Subscription subscription) {
                        YTDLPAppStream.this.subscriptions.put(YTDLPSubscriptionBuilder.this.subscriberId, subscription);
                        subscription.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(String item) {
                        YTDLPSubscriptionBuilder.this.onOutput.accept(item);
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        YTDLPAppStream.this.subscriptions.remove(YTDLPSubscriptionBuilder.this.subscriberId);
                        YTDLPSubscriptionBuilder.this.onError.accept(throwable);
                    }

                    @Override
                    public void onComplete() {
                        YTDLPAppStream.this.subscriptions.remove(YTDLPSubscriptionBuilder.this.subscriberId);
                        YTDLPSubscriptionBuilder.this.onComplete.run();
                    }
                });
            }
        }
    }
}

