/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.config;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.dented.downloadingdiscs.config.Config;
import net.dented.downloadingdiscs.config.DiscWriterOutputOption;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends class_4667 {
    private DDOptionListWidget list;
    private IntFieldEntry connectionTimeoutEntry;
    private IntFieldEntry downloadTimeoutEntry;
    private IntFieldEntry urlCharacterLimitEntry;
    private IntFieldEntry titleCharacterLimitEntry;
    private static final int LABEL_COLOR = -393218;
    private static final int FIELD_MAX_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private static final int ROW_HEIGHT = 36;

    public ConfigScreen(class_437 parent) {
        super(parent, class_310.method_1551().field_1690, (class_2561)class_2561.method_43471((String)"config.downloadingdiscs.title"));
    }

    protected void method_25426() {
        class_310 mc = Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551);
        this.list = new DDOptionListWidget(mc, this.field_22789, this, 36);
        this.method_37063((class_364)this.list);
        this.addConfigOptionsToList();
        this.list.addCustomEntry(new LabelEntry(this, (class_2561)class_2561.method_43471((String)"config.downloadingdiscs.connection_timeout_option")));
        this.connectionTimeoutEntry = new IntFieldEntry(this, String.valueOf(Config.connectionAttemptTimeoutSeconds));
        this.list.addCustomEntry(this.connectionTimeoutEntry);
        this.list.addCustomEntry(new LabelEntry(this, (class_2561)class_2561.method_43471((String)"config.downloadingdiscs.download_timeout_option")));
        this.downloadTimeoutEntry = new IntFieldEntry(this, String.valueOf(Config.downloadTimeoutMinutes));
        this.list.addCustomEntry(this.downloadTimeoutEntry);
        this.list.addCustomEntry(new LabelEntry(this, (class_2561)class_2561.method_43471((String)"config.downloadingdiscs.disc_writer_url_character_limit_option")));
        this.urlCharacterLimitEntry = new IntFieldEntry(this, String.valueOf(Config.discWriterUrlCharacterLimit));
        this.list.addCustomEntry(this.urlCharacterLimitEntry);
        this.list.addCustomEntry(new LabelEntry(this, (class_2561)class_2561.method_43471((String)"config.downloadingdiscs.disc_writer_title_character_limit_option")));
        this.titleCharacterLimitEntry = new IntFieldEntry(this, String.valueOf(Config.discWriterTitleCharacterLimit));
        this.list.addCustomEntry(this.titleCharacterLimitEntry);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.onDone()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, b -> this.onCancel()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
    }

    protected void method_60325() {
    }

    private void addConfigOptionsToList() {
        this.list.method_20406(new class_7172("config.downloadingdiscs.disc_writer_output_option.tooltip", option -> class_7919.method_47407((class_2561)class_2561.method_43471((String)option.getTooltipKey())), class_7172.method_42720(), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList(DiscWriterOutputOption.values()), Codec.INT.xmap(DiscWriterOutputOption::fromId, DiscWriterOutputOption::method_7362)), (Object)Config.discWriterOutput, option -> {
            Config.discWriterOutput = option;
        }));
        this.list.method_20406(new class_7172("config.downloadingdiscs.disc_writer_permission_level_option.tooltip", class_7172.method_42717((class_2561)class_2561.method_43471((String)"config.downloadingdiscs.disc_writer_permission_level.tooltip")), (component, integer) -> class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{component, class_2561.method_43469((String)"config.downloadingdiscs.disc_writer_permission_level_value", (Object[])new Object[]{integer})}), (class_7172.class_7178)new class_7172.class_7174(0, 4), (Object)Config.discWriterMinimumPermissionLevel, integer -> {
            Config.discWriterMinimumPermissionLevel = integer;
        }));
        this.list.method_20406(new class_7172("config.downloadingdiscs.downloaded_audio_quality_option.tooltip", class_7172.method_42717((class_2561)class_2561.method_43471((String)"config.downloadingdiscs.downloaded_audio_quality.tooltip")), (component, integer) -> class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{component, class_2561.method_43469((String)"config.downloadingdiscs.downloaded_audio_quality_value", (Object[])new Object[]{integer})}), (class_7172.class_7178)new class_7172.class_7174(64, 320), (Object)Config.downloadedAudioBitrateKbps, integer -> {
            Config.downloadedAudioBitrateKbps = integer;
        }));
    }

    public void method_25394(@NotNull class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, -393218);
    }

    public void method_25410(class_310 client, int width, int height) {
        String c = this.connectionTimeoutEntry != null ? this.connectionTimeoutEntry.getText() : "";
        String d = this.downloadTimeoutEntry != null ? this.downloadTimeoutEntry.getText() : "";
        String u = this.urlCharacterLimitEntry != null ? this.urlCharacterLimitEntry.getText() : "";
        String t = this.titleCharacterLimitEntry != null ? this.titleCharacterLimitEntry.getText() : "";
        this.field_22789 = width;
        this.field_22790 = height;
        this.field_22787 = client;
        this.method_37067();
        this.method_48267();
        this.method_25426();
        if (this.connectionTimeoutEntry != null) {
            this.connectionTimeoutEntry.setText(c);
        }
        if (this.downloadTimeoutEntry != null) {
            this.downloadTimeoutEntry.setText(d);
        }
        if (this.urlCharacterLimitEntry != null) {
            this.urlCharacterLimitEntry.setText(u);
        }
        if (this.titleCharacterLimitEntry != null) {
            this.titleCharacterLimitEntry.setText(t);
        }
    }

    private void onDone() {
        Config.connectionAttemptTimeoutSeconds = this.connectionTimeoutEntry.getInt(Config.connectionAttemptTimeoutSeconds);
        Config.downloadTimeoutMinutes = this.downloadTimeoutEntry.getInt(Config.downloadTimeoutMinutes);
        Config.discWriterUrlCharacterLimit = this.urlCharacterLimitEntry.getInt(Config.discWriterUrlCharacterLimit);
        Config.discWriterTitleCharacterLimit = this.titleCharacterLimitEntry.getInt(Config.discWriterTitleCharacterLimit);
        Config.writeConfigToFile();
        Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551).method_1507(this.field_21335);
    }

    private void onCancel() {
        Config.loadConfigFromFile();
        Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551).method_1507(this.field_21335);
    }

    public void method_25432() {
        Config.loadConfigFromFile();
    }

    private static class DDOptionListWidget
    extends class_353 {
        private final int rowHeight;

        DDOptionListWidget(class_310 client, int width, class_4667 parent, int rowHeight) {
            super(client, width, parent);
            this.rowHeight = rowHeight;
        }

        public void addCustomEntry(class_353.class_354 entry) {
            super.method_25321((class_350.class_351)entry);
        }
    }

    private static class LabelEntry
    extends class_353.class_354 {
        private final ConfigScreen parent;
        private final class_2561 label;

        LabelEntry(ConfigScreen parent, class_2561 label) {
            super(Collections.emptyList(), (class_437)parent);
            this.parent = parent;
            this.label = label;
        }

        public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            int labelX = x + 10;
            Objects.requireNonNull(this.parent.field_22793);
            int labelY = y + (entryHeight - 9) / 2;
            ctx.method_27535(this.parent.field_22793, this.label, labelX, labelY, -393218);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    private static class IntFieldEntry
    extends class_353.class_354 {
        private final ConfigScreen parent;
        private final class_342 field;

        IntFieldEntry(ConfigScreen parent, String initialText) {
            super(Collections.emptyList(), (class_437)parent);
            this.parent = parent;
            this.field = new class_342(parent.field_22793, 0, 0, Math.min(150, parent.field_22789 - 40), 20, (class_2561)class_2561.method_43470((String)""));
            this.field.method_1880(8);
            this.field.method_1852(initialText);
            this.field.method_1856(true);
        }

        String getText() {
            return this.field.method_1882();
        }

        void setText(String text) {
            this.field.method_1852(text);
        }

        int getInt(int fallback) {
            try {
                return Integer.parseInt(this.field.method_1882());
            }
            catch (NumberFormatException e) {
                return fallback;
            }
        }

        public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            int w = Math.min(150, this.parent.field_22789 - 40);
            if (w != this.field.method_25368()) {
                this.field.method_25358(w);
            }
            int fieldX = x + (entryWidth - this.field.method_25368()) / 2;
            int fieldY = y + (entryHeight - this.field.method_25364()) / 2;
            this.field.method_46421(fieldX);
            this.field.method_46419(fieldY);
            boolean valid = IntFieldEntry.isInteger(this.field.method_1882());
            this.field.method_1868(valid ? -393218 : -5231066);
            this.field.method_25394(ctx, mouseX, mouseY, delta);
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.field);
        }

        public List<? extends class_6379> method_37025() {
            return this.method_25396();
        }

        private static boolean isInteger(String s) {
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

