/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.util;

import de.maxhenkel.audioplayer.AudioManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.dented.downloadingdiscs.config.DiscWriterOutputOption;
import net.dented.downloadingdiscs.util.DownloadableAudioMapManager;
import net.dented.downloadingdiscs.util.DownloadedAudioHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class DiscValidator {
    private final class_3218 serverWorld;
    private final class_1657 player;
    private final class_1799 stack;
    private final String url;
    private final DiscWriterOutputOption outputOption;

    public DiscValidator(class_3218 world, class_1657 player, class_1799 stack, String url, DiscWriterOutputOption outputOption) {
        this.serverWorld = world;
        this.player = player;
        this.stack = stack;
        this.url = url == null ? "" : url;
        this.outputOption = outputOption;
    }

    public boolean validate() {
        boolean validated = false;
        UUID uuid = UUID.randomUUID();
        class_9279 customData = (class_9279)this.stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (this.url.isBlank()) {
            if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
                this.player.method_7353((class_2561)class_2561.method_43471((String)"message.downloadingdiscs.disc_erased"), false);
            }
            return false;
        }
        if (!DownloadableAudioMapManager.isURLPresent(this.url)) {
            DownloadedAudioHandler handler = new DownloadedAudioHandler(this.serverWorld, uuid, this.url);
            if (handler.isValidConnection()) {
                tag.method_67494("CustomSound", class_4844.field_25122, (Object)uuid);
                this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                if (this.outputOption == DiscWriterOutputOption.ALL) {
                    this.player.method_7353((class_2561)class_2561.method_43471((String)"message.downloadingdiscs.valid_url"), false);
                }
                DownloadableAudioMapManager.addAttemptedURL(uuid, this.url);
                DownloadableAudioMapManager.writeMapToFile(this.serverWorld);
                if (handler.downloadAudioFile()) {
                    if (handler.validateAudioFileIntegrity() && handler.validateAudioFileSize(false) && handler.validateAudioFileDuration(false) && handler.registerAudioFileWithAudioPlayer()) {
                        if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
                            this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.registration_success", (Object[])new Object[]{this.url}), false);
                        }
                        validated = true;
                        tag.method_67494("CustomSound", class_4844.field_25122, (Object)uuid);
                        this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                    } else {
                        this.failMessage("registration_fail");
                    }
                } else {
                    this.failMessage("download_failed");
                }
            } else {
                this.failMessage("invalid_url");
            }
        } else {
            UUID downloadedUUID = DownloadableAudioMapManager.getUUIDfromURL(this.url);
            tag.method_67494("CustomSound", class_4844.field_25122, (Object)downloadedUUID);
            this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            if (this.outputOption == DiscWriterOutputOption.ALL) {
                this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.already_attempted", (Object[])new Object[]{this.url}), false);
            }
            Path downloadedFile = this.serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")).resolve(String.valueOf(downloadedUUID) + ".mp3");
            Path registeredFile = this.serverWorld.method_8503().method_27050(AudioManager.AUDIO_DATA).resolve(String.valueOf(downloadedUUID) + ".mp3");
            DownloadedAudioHandler handler = new DownloadedAudioHandler(this.serverWorld, downloadedUUID, this.url);
            if (!Files.exists(registeredFile, new LinkOption[0])) {
                if (this.outputOption == DiscWriterOutputOption.ALL) {
                    this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.not_registered", (Object[])new Object[]{this.url}), false);
                }
                if (Files.exists(downloadedFile, new LinkOption[0])) {
                    validated = this.revalidateAndRegister(handler, downloadedUUID, tag);
                } else {
                    if (this.outputOption == DiscWriterOutputOption.ALL) {
                        this.player.method_7353((class_2561)class_2561.method_43471((String)"message.downloadingdiscs.file_missing"), false);
                    }
                    validated = this.tryRedownload(handler, downloadedUUID, tag);
                }
            } else if (handler.validateAudioFileSize(true) && handler.validateAudioFileDuration(true)) {
                tag.method_67494("CustomSound", class_4844.field_25122, (Object)downloadedUUID);
                this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
                    this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.already_registered", (Object[])new Object[]{this.url}), false);
                }
                validated = true;
            } else {
                this.failMessage("file_too_large");
            }
        }
        return validated;
    }

    private void failMessage(String key) {
        if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
            this.player.method_7353((class_2561)class_2561.method_43469((String)("message.downloadingdiscs." + key), (Object[])new Object[]{this.url}), false);
        }
    }

    private boolean revalidateAndRegister(DownloadedAudioHandler handler, UUID uuid, class_2487 tag) {
        if (handler.validateAudioFileSize(false) && handler.validateAudioFileDuration(false) && handler.registerAudioFileWithAudioPlayer()) {
            tag.method_67494("CustomSound", class_4844.field_25122, (Object)uuid);
            this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
                this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.registration_success", (Object[])new Object[]{this.url}), false);
            }
            return true;
        }
        this.failMessage("registration_fail");
        return false;
    }

    private boolean tryRedownload(DownloadedAudioHandler handler, UUID uuid, class_2487 tag) {
        if (handler.isValidConnection() && handler.downloadAudioFile() && handler.validateAudioFileIntegrity() && handler.validateAudioFileSize(false) && handler.validateAudioFileDuration(false) && handler.registerAudioFileWithAudioPlayer()) {
            tag.method_67494("CustomSound", class_4844.field_25122, (Object)uuid);
            this.stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            if (this.outputOption == DiscWriterOutputOption.ALL || this.outputOption == DiscWriterOutputOption.ON_COMPLETE) {
                this.player.method_7353((class_2561)class_2561.method_43469((String)"message.downloadingdiscs.registration_success", (Object[])new Object[]{this.url}), false);
            }
            return true;
        }
        this.failMessage("download_failed");
        return false;
    }
}

