/*
 * Decompiled with CFR 0.152.
 */
package net.dented.downloadingdiscs.util;

import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.FileNameManager;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.audioplayer.VolumeOverrideManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.dented.downloadingdiscs.DownloadingDiscsMod;
import net.dented.downloadingdiscs.apps.FFMpegApp;
import net.dented.downloadingdiscs.apps.YTDLPApp;
import net.dented.downloadingdiscs.config.Config;
import net.dented.downloadingdiscs.util.DownloadableAudioMapManager;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import org.apache.commons.io.FileUtils;

public class DownloadedAudioHandler {
    private class_3218 serverWorld;
    private UUID uuid;
    private String url;
    private Path file;
    private Path registeredFile;

    public DownloadedAudioHandler(class_3218 serverWorld, UUID uuid, String url) {
        this.serverWorld = serverWorld;
        this.uuid = uuid;
        this.url = url;
        this.file = serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")).resolve(uuid.toString() + ".mp3");
        this.registeredFile = serverWorld.method_8503().method_27050(AudioManager.AUDIO_DATA).resolve(uuid.toString() + ".mp3");
    }

    public boolean isValidConnection() {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(Config.connectionAttemptTimeoutSeconds)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url)).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(Config.connectionAttemptTimeoutSeconds)).build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            int status = response.statusCode();
            return status >= 200 && status < 400;
        }
        catch (Exception e) {
            DownloadingDiscsMod.LOGGER.warn("Error during connection test");
            return false;
        }
    }

    public boolean downloadAudioFile() {
        Path downloadDir = this.serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads"));
        try {
            Files.createDirectories(downloadDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.error("Failed to create download directory: " + String.valueOf(e));
            return false;
        }
        Path tmpFile = downloadDir.resolve(String.valueOf(this.uuid) + ".tmp.mp3");
        Path finalFile = downloadDir.resolve(String.valueOf(this.uuid) + ".mp3");
        CompletableFuture downloadFuture = new CompletableFuture();
        YTDLPApp ytdlp = new YTDLPApp();
        ytdlp.executeCommand(String.valueOf(this.uuid) + "/download", this.url, "-x", "-q", "--progress", "--add-metadata", "--no-playlist", "--progress-template", "%(progress._percent)d", "--newline", "--break-match-filter", "ext~=3gp|aac|flv|m4a|mov|mp3|mp4|ogg|wav|webm|opus", "--audio-format", "mp3", "--postprocessor-args", "ffmpeg:-ac 1 -c:a libmp3lame -b:a " + Config.downloadedAudioBitrateKbps + "k", "-P", downloadDir.toString(), "--ffmpeg-location", FFMpegApp.getDirectory().toString(), "-o", tmpFile.getFileName().toString()).subscribe(String.valueOf(this.uuid)).onOutput(line -> {}).onError(error -> {
            DownloadingDiscsMod.LOGGER.warn("Error during audio download: " + String.valueOf(error));
            this.deleteFile();
            DownloadableAudioMapManager.removeDownloadedAudio(this.uuid);
            DownloadableAudioMapManager.writeMapToFile(this.serverWorld);
            downloadFuture.complete(false);
        }).onComplete(() -> {
            try {
                byte[] fileBytes = Files.readAllBytes(tmpFile);
                float volume = VolumeOverrideManager.instance().map(mgr -> Float.valueOf(mgr.getAudioVolume(this.uuid))).orElse(Float.valueOf(1.0f)).floatValue();
                short[] audioData = Plugin.voicechatApi.getAudioConverter().bytesToShorts(fileBytes);
                Files.write(finalFile, Plugin.voicechatApi.getAudioConverter().shortsToBytes(audioData), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Files.deleteIfExists(tmpFile);
                DownloadingDiscsMod.LOGGER.info("Audio download for UUID {} completed", (Object)this.uuid);
                downloadFuture.complete(true);
            }
            catch (IOException e) {
                DownloadingDiscsMod.LOGGER.error("Error during MP3 conversion: ", (Throwable)e);
                this.deleteFile();
                downloadFuture.complete(false);
            }
        }).start();
        try {
            return (Boolean)downloadFuture.get(Config.downloadTimeoutMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException | TimeoutException e) {
            DownloadingDiscsMod.LOGGER.warn("Download failed or timed out: " + String.valueOf(e));
            return false;
        }
    }

    public boolean validateAudioFileDuration(boolean useRegisteredFile) {
        Path fileToUse = useRegisteredFile ? this.registeredFile : this.file;
        float volume = VolumeOverrideManager.instance().map(mgr -> Float.valueOf(mgr.getAudioVolume(this.uuid))).orElse(Float.valueOf(1.0f)).floatValue();
        try {
            short[] audio;
            try (InputStream stream = Files.newInputStream(fileToUse, new OpenOption[0]);){
                byte[] bytes = stream.readAllBytes();
                audio = Plugin.voicechatApi.getAudioConverter().bytesToShorts(bytes);
            }
            if (AudioManager.getLengthSeconds((short[])audio) > (float)((Integer)AudioPlayer.SERVER_CONFIG.maxMusicDiscDuration.get()).intValue()) {
                DownloadingDiscsMod.LOGGER.warn("Audio file exceeds maximum duration of {}", AudioPlayer.SERVER_CONFIG.maxMusicDiscDuration.get());
                return false;
            }
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.warn("Exception during audio file duration validation: " + String.valueOf(e));
            return false;
        }
        return true;
    }

    public boolean validateAudioFileIntegrity() {
        Path filePath = this.serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")).resolve(String.valueOf(this.uuid) + ".mp3");
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            DownloadingDiscsMod.LOGGER.info("Audio file '" + String.valueOf(this.uuid) + ".mp3' download complete");
            return true;
        }
        DownloadingDiscsMod.LOGGER.info("Error during downloaded audio file validation");
        this.deleteFile();
        DownloadableAudioMapManager.removeDownloadedAudio(this.uuid);
        DownloadableAudioMapManager.writeMapToFile(this.serverWorld);
        return false;
    }

    public boolean validateAudioFileSize(boolean useRegisteredFile) {
        Path fileToUse = useRegisteredFile ? this.registeredFile : this.file;
        long size = 0L;
        try {
            size = Files.size(fileToUse);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.warn("IOException during audio file size validation");
            return false;
        }
        if (size > (Long)AudioPlayer.SERVER_CONFIG.maxUploadSize.get()) {
            DownloadingDiscsMod.LOGGER.warn("Audio file exceeds maximum size (%sMB>%sMB)".formatted(Math.round((float)size / 1000000.0f), Math.round(((Long)AudioPlayer.SERVER_CONFIG.maxUploadSize.get()).floatValue() / 1000000.0f)));
            return false;
        }
        return true;
    }

    public boolean registerAudioFileWithAudioPlayer() {
        Path soundFile = this.serverWorld.method_8503().method_27050(AudioManager.AUDIO_DATA).resolve(String.valueOf(this.uuid) + ".mp3");
        try {
            Files.createDirectories(soundFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.error("Failed to create directories for {}: {}", (Object)soundFile.getParent(), (Object)e);
            return false;
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            DownloadingDiscsMod.LOGGER.error("Source file {} does not exist", (Object)this.file);
            return false;
        }
        try {
            Files.copy(this.file, soundFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            DownloadingDiscsMod.LOGGER.error("Failed to copy {} -> {}: {}", new Object[]{this.file, soundFile, e});
            return false;
        }
        DownloadingDiscsMod.LOGGER.info("Audio file {} successfully registered with AudioPlayer", (Object)this.uuid);
        FileNameManager.instance().ifPresent(mgr -> mgr.addFileName(this.uuid, String.valueOf(this.uuid) + ".mp3"));
        return true;
    }

    public boolean deleteFile() {
        File[] filesToDelete = this.serverWorld.method_8503().method_27050(new class_5218("downloading_discs_downloads")).toFile().listFiles(file -> file.getName().contains(this.uuid.toString()));
        if (filesToDelete == null) {
            DownloadingDiscsMod.LOGGER.warn("Audio file '" + this.uuid.toString() + ".mp3' failed to be deleted");
            return false;
        }
        for (File file2 : filesToDelete) {
            FileUtils.deleteQuietly((File)file2);
            DownloadingDiscsMod.LOGGER.warn("Audio file '" + this.uuid.toString() + ".mp3' was deleted");
        }
        return true;
    }
}

