/*
 * Decompiled with CFR 0.152.
 */
package me.vital1ks.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Stack;
import net.minecraft.class_2561;

public class Calculator {
    public char[] allOperations = new char[]{'+', '-', '*', '/', '(', ')', '^'};
    public String allowedCharacters = "01234567890+-*/.()^";
    public HashMap<Character, Integer> operationsPriority = new HashMap();

    public Calculator() {
        this.operationsPriority.put(Character.valueOf('('), -1);
        this.operationsPriority.put(Character.valueOf(')'), -1);
        this.operationsPriority.put(Character.valueOf('+'), 1);
        this.operationsPriority.put(Character.valueOf('-'), 1);
        this.operationsPriority.put(Character.valueOf('*'), 2);
        this.operationsPriority.put(Character.valueOf('/'), 2);
        this.operationsPriority.put(Character.valueOf('^'), 3);
    }

    public ArrayList<String> splitString(String inputText) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (inputText.charAt(0) != '=') {
            return tokens;
        }
        inputText = inputText.substring(1);
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < inputText.length(); ++i) {
            char currentChar = inputText.charAt(i);
            if (!this.isOperation(currentChar, this.allOperations)) {
                if (currentChar == ',') {
                    token.append('.');
                    continue;
                }
                token.append(currentChar);
                continue;
            }
            tokens.add(token.toString());
            tokens.add(String.valueOf(currentChar));
            token = new StringBuilder();
        }
        tokens.add(token.toString());
        tokens = this.clearTokens(tokens);
        tokens = this.fixNegative(tokens);
        return tokens;
    }

    public boolean isOperation(char character, char[] operations) {
        for (char operation : operations) {
            if (operation != character) continue;
            return true;
        }
        return false;
    }

    public class_2561 calculateAnswer(ArrayList<String> tokens) {
        return this.calculateAnswer(tokens, false);
    }

    public class_2561 calculateAnswer(ArrayList<String> tokens, boolean isServerside) {
        Stack<Float> numbers = new Stack<Float>();
        Stack<Character> operations = new Stack<Character>();
        if (!this.checkBrackets(tokens)) {
            return isServerside ? class_2561.method_43470((String)"Wrong Brackets").method_54663(16744704) : class_2561.method_43471((String)"message.mineculator.wrong_brackets").method_54663(16744704);
        }
        for (String token : tokens) {
            if (this.hasWrongCharacters(token)) {
                return isServerside ? class_2561.method_43470((String)"Wrong Character").method_54663(16762880) : class_2561.method_43471((String)"message.mineculator.wrong_character").method_54663(16762880);
            }
            if (token.length() == 1) {
                if (this.isOperation(token.charAt(0), this.allOperations)) {
                    float newNumber;
                    float number1;
                    float number2;
                    char operation = token.charAt(0);
                    if (operations.empty()) {
                        operations.add(Character.valueOf(operation));
                        continue;
                    }
                    if (this.getPriority(operation) == -1) {
                        if (operation == '(') {
                            operations.add(Character.valueOf(operation));
                            continue;
                        }
                        while (((Character)operations.peek()).charValue() != '(') {
                            if (numbers.empty()) {
                                return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
                            }
                            number2 = ((Float)numbers.pop()).floatValue();
                            if (numbers.empty()) {
                                return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
                            }
                            number1 = ((Float)numbers.pop()).floatValue();
                            newNumber = this.makeOperation(number1, ((Character)operations.pop()).charValue(), number2);
                            numbers.add(Float.valueOf(newNumber));
                        }
                        operations.pop();
                        continue;
                    }
                    if (this.getPriority(operation) > this.getPriority(((Character)operations.peek()).charValue())) {
                        operations.add(Character.valueOf(operation));
                        continue;
                    }
                    if (numbers.empty()) {
                        return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
                    }
                    number2 = ((Float)numbers.pop()).floatValue();
                    if (numbers.empty()) {
                        return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
                    }
                    number1 = ((Float)numbers.pop()).floatValue();
                    newNumber = this.makeOperation(number1, ((Character)operations.pop()).charValue(), number2);
                    numbers.add(Float.valueOf(newNumber));
                    operations.add(Character.valueOf(operation));
                    continue;
                }
                if (!this.isFloat(token)) continue;
                numbers.add(Float.valueOf(Float.parseFloat(token)));
                continue;
            }
            if (!this.isFloat(token)) continue;
            numbers.add(Float.valueOf(Float.parseFloat(token)));
        }
        while (!operations.empty()) {
            if (numbers.empty()) {
                return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
            }
            float number2 = ((Float)numbers.pop()).floatValue();
            if (numbers.empty()) {
                return isServerside ? class_2561.method_43470((String)"Wrong Formula").method_54663(0xFF0000) : class_2561.method_43471((String)"message.mineculator.wrong_formula").method_54663(0xFF0000);
            }
            float number1 = ((Float)numbers.pop()).floatValue();
            float newNumber = this.makeOperation(number1, ((Character)operations.pop()).charValue(), number2);
            numbers.add(Float.valueOf(newNumber));
        }
        if (!numbers.empty()) {
            return class_2561.method_43470((String)String.format("%.2f", numbers.pop())).method_54663(4371445);
        }
        return isServerside ? class_2561.method_43470((String)"Error").method_54663(10814750) : class_2561.method_43471((String)"message.mineculator.error").method_54663(10814750);
    }

    public int getPriority(char operation) {
        return this.operationsPriority.get(Character.valueOf(operation));
    }

    public float makeOperation(float number1, char operation, float number2) {
        return switch (operation) {
            case '+' -> number1 + number2;
            case '-' -> number1 - number2;
            case '*' -> number1 * number2;
            case '/' -> number1 / number2;
            case '^' -> (float)Math.pow(number1, number2);
            default -> number1;
        };
    }

    public boolean hasWrongCharacters(String inputString) {
        for (int i = 0; i < inputString.length(); ++i) {
            if (this.allowedCharacters.contains(String.valueOf(inputString.charAt(i)))) continue;
            return true;
        }
        return false;
    }

    public boolean isFloat(String number) {
        number = number.replace('.', ',');
        Scanner scanner = new Scanner(number);
        return scanner.hasNextFloat();
    }

    public boolean checkBrackets(ArrayList<String> tokens) {
        int openBrackets = 0;
        int closeBrackets = 0;
        for (String token : tokens) {
            if (token.equals("(")) {
                ++openBrackets;
            }
            if (!token.equals(")")) continue;
            ++closeBrackets;
        }
        return openBrackets == closeBrackets;
    }

    public ArrayList<String> clearTokens(ArrayList<String> tokens) {
        ArrayList<String> newTokens = new ArrayList<String>();
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            newTokens.add(token);
        }
        return newTokens;
    }

    public ArrayList<String> fixNegative(ArrayList<String> tokens) {
        ArrayList<String> newTokens = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).equals("-")) {
                if (i == 0) {
                    newTokens.add("(");
                    newTokens.add("0");
                    newTokens.add("-");
                    newTokens.add(tokens.get(i + 1));
                    newTokens.add(")");
                    ++i;
                    continue;
                }
                if (this.isOperation(tokens.get(i - 1).charAt(0), this.allOperations)) {
                    newTokens.add("(");
                    newTokens.add("0");
                    newTokens.add("-");
                    newTokens.add(tokens.get(i + 1));
                    newTokens.add(")");
                    ++i;
                    continue;
                }
                newTokens.add(tokens.get(i));
                continue;
            }
            newTokens.add(tokens.get(i));
        }
        return newTokens;
    }
}

