/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer;

import com.spunkyinsaan.lagfixer.commands.AbyssCommand;
import com.spunkyinsaan.lagfixer.commands.LagFixerCommand;
import com.spunkyinsaan.lagfixer.features.AntiRedstone;
import com.spunkyinsaan.lagfixer.features.ConsoleFilter;
import com.spunkyinsaan.lagfixer.features.CustomAI;
import com.spunkyinsaan.lagfixer.features.EntityLimiter;
import com.spunkyinsaan.lagfixer.features.ItemsCleaner;
import com.spunkyinsaan.lagfixer.features.LagMonitor;
import com.spunkyinsaan.lagfixer.listeners.PlayerJoinListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpunkysLagFixer
extends JavaPlugin {
    private CustomAI customAI;
    private ItemsCleaner itemsCleaner;
    private EntityLimiter entityLimiter;
    private LagMonitor lagMonitor;
    private AntiRedstone antiRedstone;
    private ConsoleFilter consoleFilter;

    public void onEnable() {
        this.saveDefaultConfig();
        this.initializeFeatures();
        this.getCommand("spunkylagfix").setExecutor((CommandExecutor)new LagFixerCommand(this));
        this.getCommand("abyss").setExecutor((CommandExecutor)new AbyssCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getLogger().info("SpunkyLagFix has been enabled!");
    }

    public void initializeFeatures() {
        this.customAI = new CustomAI(this);
        this.itemsCleaner = new ItemsCleaner(this);
        this.entityLimiter = new EntityLimiter(this);
        this.lagMonitor = new LagMonitor(this);
        this.antiRedstone = new AntiRedstone(this);
        this.consoleFilter = new ConsoleFilter(this);
        this.loadFeatureSettings();
    }

    private void loadFeatureSettings() {
        this.customAI.setEnabled(this.getConfig().getBoolean("custom-ai.enabled", true));
        this.itemsCleaner.setEnabled(this.getConfig().getBoolean("items-cleaner.enabled", true));
        this.entityLimiter.setEnabled(this.getConfig().getBoolean("entity-limiter.enabled", true));
        this.antiRedstone.setEnabled(this.getConfig().getBoolean("anti-redstone.enabled", true));
    }

    public void onDisable() {
        if (this.itemsCleaner != null) {
            this.itemsCleaner.shutdown();
        }
        if (this.lagMonitor != null) {
            this.lagMonitor.shutdown();
        }
        this.getLogger().info("SpunkyLagFix has been disabled!");
    }

    public CustomAI getCustomAI() {
        return this.customAI;
    }

    public ItemsCleaner getItemsCleaner() {
        return this.itemsCleaner;
    }

    public EntityLimiter getEntityLimiter() {
        return this.entityLimiter;
    }

    public LagMonitor getLagMonitor() {
        return this.lagMonitor;
    }

    public AntiRedstone getAntiRedstone() {
        return this.antiRedstone;
    }

    public ConsoleFilter getConsoleFilter() {
        return this.consoleFilter;
    }
}

