/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.commands;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;

public class LagFixerCommand
implements CommandExecutor,
TabCompleter {
    private final SpunkysLagFixer plugin;
    private final List<String> subcommands = Arrays.asList("reload", "status", "clean", "optimize", "toggle-ai", "toggle-cleaner", "toggle-limiter", "toggle-redstone", "help", "killmobs", "clearentity");

    public LagFixerCommand(SpunkysLagFixer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("spunkylagfix.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadPlugin(sender);
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "status": {
                this.sendStatus(sender);
                break;
            }
            case "clean": {
                this.plugin.getItemsCleaner().cleanNow();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Started cleaning items!");
                break;
            }
            case "optimize": {
                this.performOptimization(sender);
                break;
            }
            case "killmobs": {
                this.killMobs(sender);
                break;
            }
            case "clearentity": {
                this.clearEntities(sender);
                break;
            }
            case "toggle-ai": {
                this.toggleFeature(sender, "CustomAI", this.plugin.getCustomAI()::setEnabled);
                break;
            }
            case "toggle-cleaner": {
                this.toggleFeature(sender, "ItemsCleaner", this.plugin.getItemsCleaner()::setEnabled);
                break;
            }
            case "toggle-limiter": {
                this.toggleFeature(sender, "EntityLimiter", this.plugin.getEntityLimiter()::setEnabled);
                break;
            }
            case "toggle-redstone": {
                this.toggleFeature(sender, "AntiRedstone", this.plugin.getAntiRedstone()::setEnabled);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use /spunkylagfix help for help.");
            }
        }
        return true;
    }

    private void killMobs(CommandSender sender) {
        int count = 0;
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || entity instanceof Player || !(entity instanceof Monster) && !(entity instanceof Animals) && !(entity instanceof Ambient)) continue;
                entity.remove();
                ++count;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully removed " + count + " mobs from all worlds!");
        System.gc();
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Memory cleaned up.");
    }

    private void clearEntities(CommandSender sender) {
        int count = 0;
        HashMap<EntityType, Integer> removedEntities = new HashMap<EntityType, Integer>();
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!this.shouldRemoveEntity(entity)) continue;
                removedEntities.merge(entity.getType(), 1, Integer::sum);
                entity.remove();
                ++count;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=== Entity Cleanup Report ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total entities removed: " + count);
        if (!removedEntities.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Breakdown:");
            removedEntities.forEach((type, amount) -> sender.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + type.name() + ": " + amount));
        }
        System.gc();
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Memory cleaned up.");
    }

    private boolean shouldRemoveEntity(Entity entity) {
        return entity instanceof Item || entity instanceof Minecart || entity instanceof Boat || entity instanceof ExperienceOrb || entity instanceof Arrow || entity instanceof Projectile && !(entity instanceof Trident) || entity instanceof FallingBlock;
    }

    private void reloadPlugin(CommandSender sender) {
        try {
            this.plugin.saveDefaultConfig();
            this.plugin.reloadConfig();
            this.plugin.getItemsCleaner().shutdown();
            this.plugin.getLagMonitor().shutdown();
            this.plugin.initializeFeatures();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "SpunkyLagFix has been reloaded successfully!");
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while reloading the plugin!");
            e.printStackTrace();
        }
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=== SpunkyLagFix Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix reload " + String.valueOf(ChatColor.WHITE) + "- Reload plugin configuration");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix status " + String.valueOf(ChatColor.WHITE) + "- Show server status");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix clean " + String.valueOf(ChatColor.WHITE) + "- Clean items now");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix optimize " + String.valueOf(ChatColor.WHITE) + "- Run optimization");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix killmobs " + String.valueOf(ChatColor.WHITE) + "- Remove all mobs from worlds");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix clearentity " + String.valueOf(ChatColor.WHITE) + "- Clear entities like minecarts, items, etc.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix toggle-ai " + String.valueOf(ChatColor.WHITE) + "- Toggle CustomAI");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix toggle-cleaner " + String.valueOf(ChatColor.WHITE) + "- Toggle ItemsCleaner");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix toggle-limiter " + String.valueOf(ChatColor.WHITE) + "- Toggle EntityLimiter");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/spunkylagfix toggle-redstone " + String.valueOf(ChatColor.WHITE) + "- Toggle AntiRedstone");
    }

    private void sendStatus(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=== SpunkyLagFix Status ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TPS: " + String.format("%.2f", this.plugin.getLagMonitor().getTPS()));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Features:");
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- CustomAI: " + this.getStatusColor(this.plugin.getCustomAI().isEnabled()));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- ItemsCleaner: " + this.getStatusColor(this.plugin.getItemsCleaner().isEnabled()));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- EntityLimiter: " + this.getStatusColor(this.plugin.getEntityLimiter().isEnabled()));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "- AntiRedstone: " + this.getStatusColor(this.plugin.getAntiRedstone().isEnabled()));
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L / 1024L;
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Memory Usage: " + usedMemory + "MB / " + maxMemory + "MB");
    }

    private String getStatusColor(boolean enabled) {
        return enabled ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled";
    }

    private void performOptimization(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Starting optimization...");
        this.plugin.getEntityLimiter().enforceLimit();
        this.plugin.getItemsCleaner().cleanNow();
        System.gc();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Optimization complete!");
    }

    private void toggleFeature(CommandSender sender, String name, Consumer<Boolean> toggle) {
        toggle.accept(true);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + name + " has been toggled!");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("spunkylagfix.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return this.subcommands.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

