/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.features;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

public class AntiRedstone
implements Listener {
    private final SpunkysLagFixer plugin;
    private final Map<String, Integer> pulseCount = new HashMap<String, Integer>();
    private boolean enabled = true;
    private static final int MAX_PULSES = 100;
    private static final int RESET_TICKS = 100;

    public AntiRedstone(SpunkysLagFixer plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onRedstone(BlockRedstoneEvent event) {
        if (!this.enabled) {
            return;
        }
        Block block = event.getBlock();
        String loc = this.blockToString(block);
        if (this.isRedstoneClock(block)) {
            this.pulseCount.merge(loc, 1, Integer::sum);
            if (this.pulseCount.get(loc) > 100) {
                event.setNewCurrent(0);
                this.disableRedstoneClock(block);
            }
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.pulseCount.remove(loc), 100L);
        }
    }

    private boolean isRedstoneClock(Block block) {
        return block.getType() == Material.REDSTONE_WIRE || block.getType() == Material.REPEATER || block.getType() == Material.COMPARATOR;
    }

    private void disableRedstoneClock(Block block) {
        if (block.getType() == Material.REDSTONE_WIRE) {
            block.setType(Material.AIR);
        }
    }

    private String blockToString(Block block) {
        return block.getWorld().getName() + "," + block.getX() + "," + block.getY() + "," + block.getZ();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

