/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.features;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;

public class CustomAI
implements Listener {
    private final SpunkysLagFixer plugin;
    private boolean enabled = true;

    public CustomAI(SpunkysLagFixer plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (!this.enabled) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(entity instanceof Player)) {
            if (entity instanceof Animals) {
                this.optimizeAnimalAI((Animals)entity);
            } else if (entity instanceof Monster) {
                this.optimizeMonsterAI((Monster)entity);
            }
        }
    }

    private void optimizeAnimalAI(Animals animal) {
        animal.setAI(false);
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            boolean playerNearby = animal.getNearbyEntities(16.0, 16.0, 16.0).stream().anyMatch(e -> e instanceof Player);
            animal.setAI(playerNearby);
        }, 20L, 100L);
    }

    private void optimizeMonsterAI(Monster monster) {
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            boolean playerNearby = monster.getNearbyEntities(32.0, 32.0, 32.0).stream().anyMatch(e -> e instanceof Player);
            monster.setAI(playerNearby);
        }, 20L, 60L);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

