/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.lagfixer.features;

import com.spunkyinsaan.lagfixer.SpunkysLagFixer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class EntityLimiter
implements Listener {
    private final SpunkysLagFixer plugin;
    private final Map<EntityType, Integer> limits = new HashMap<EntityType, Integer>();
    private boolean enabled = true;

    public EntityLimiter(SpunkysLagFixer plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadLimits();
    }

    private void loadLimits() {
        this.limits.put(EntityType.ZOMBIE, 20);
        this.limits.put(EntityType.SKELETON, 20);
        this.limits.put(EntityType.SPIDER, 15);
        this.limits.put(EntityType.CHICKEN, 10);
        this.limits.put(EntityType.COW, 10);
        this.limits.put(EntityType.SHEEP, 10);
        this.limits.put(EntityType.PIG, 10);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        int count;
        if (!this.enabled) {
            return;
        }
        Chunk chunk = event.getLocation().getChunk();
        EntityType type = event.getEntityType();
        if (this.limits.containsKey(type) && (count = this.countEntitiesInChunk(chunk, type)) >= this.limits.get(type)) {
            event.setCancelled(true);
        }
    }

    private int countEntitiesInChunk(Chunk chunk, EntityType type) {
        int count = 0;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public void enforceLimit() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (Map.Entry<EntityType, Integer> limit : this.limits.entrySet()) {
                    int count = this.countEntitiesInChunk(chunk, limit.getKey());
                    if (count <= limit.getValue()) continue;
                    this.removeExcessEntities(chunk, limit.getKey(), count - limit.getValue());
                }
            }
        }
    }

    private void removeExcessEntities(Chunk chunk, EntityType type, int excess) {
        int removed = 0;
        for (Entity entity : chunk.getEntities()) {
            if (removed >= excess) break;
            if (entity.getType() != type) continue;
            entity.remove();
            ++removed;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

